# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
from ShowCommand import ShowCliCommandClass
from CliPlugin.UpnpConfigCli import nodeUpnp
from CliPlugin.IgdUpnpConfigCli import nodeIgd
from CliPlugin.VrfCli import VrfExprFactory

# show upnp igd port-map
class ShowUpnpPortMap( ShowCliCommandClass ):
   syntax = 'show upnp igd port-map'
   data = {
      'upnp': nodeUpnp,
      'igd': nodeIgd,
      'port-map': 'UPnP port map',
   }

   cliModel = "UpnpShowCliModels.UpnpPortMapInfo"
   handler = "UpnpShowCliHandler.showUpnpPortMap"

BasicCli.addShowCommandClass( ShowUpnpPortMap )

# show upnp service
class ShowUpnpServiceStatus( ShowCliCommandClass ):
   syntax = 'show upnp service'
   data = {
      'upnp': nodeUpnp,
      'service': 'UPnP Service',
   }

   cliModel = "UpnpShowCliModels.UpnpServiceInfo"
   handler = "UpnpShowCliHandler.showUpnpService"

BasicCli.addShowCommandClass( ShowUpnpServiceStatus )

# show upnp counters
class ShowUpnpCounters( ShowCliCommandClass ):
   syntax = 'show upnp counters [ VRF ]'
   data = {
            'upnp': nodeUpnp,
            'counters': 'UPNP counters',
            'VRF': VrfExprFactory( helpdesc='Show counters in a VRF' )
          }

   cliModel = "UpnpShowCliModels.UpnpCountersModel"
   handler = "UpnpShowCliHandler.showUpnpCounters"

BasicCli.addShowCommandClass( ShowUpnpCounters )
