# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import re

import Arnet
import BasicCli
# pylint: disable-next=consider-using-from-import
import CliPlugin.IgmpSnoopingCli as IgmpSnoopingCli
# pylint: disable-next=consider-using-from-import
import CliPlugin.IpAddrMatcher as IpAddrMatcher
from CliPlugin.EthIntfCli import EthPhyAutoIntfType
from CliPlugin.LagIntfCli import LagAutoIntfType
import CliToken.Ip
import CliToken.IgmpSnooping
from IgmpSnoopingModel import IgmpSnoopingProxyInfo, IgmpSnoopingProxyPorts
from IgmpSnoopingModel import IgmpSnoopingProxyGroups, IgmpSnoopingProxySourceList
from IgmpSnoopingModel import IgmpSnoopingProxyGroupInfo
from Intf.IntfRange import IntfRangeMatcher
import LazyMount
import ShowCommand

igmpHostDir = None

def doShowIpIgmpSnoopingProxyGroups( mode, args ):
   group = args.get( 'IP_ADDR' )
   groupAddr = None
   vlanId = args.get( 'VLAN_ID' )
   intfs = args.get( 'INTFS' )
   detail = 'detail' in args

   if group:
      invalidMulticast = IpAddrMatcher.validateMulticastIpAddr( group )
      if invalidMulticast:
         mode.addError( "Group filter must be a valid multicast address" )
         return None
      groupAddr = Arnet.IpGenAddr( group )
 
   if vlanId and intfs:
      hostList = [ ]
      for intfName in intfs:
         # pylint: disable-next=consider-using-f-string
         hostKey = "Vlan%d%s" % ( vlanId, intfName )
         if hostKey in igmpHostDir.igmpHost:
            hostList.append( igmpHostDir.igmpHost[ hostKey ] ) 
   else:
      if vlanId or intfs :
         if vlanId :
            pattern = "Vlan%d.*" % vlanId # pylint: disable=consider-using-f-string
            regExp = re.compile( pattern )
            hostList = [ v for ( k, v ) in igmpHostDir.igmpHost.items() 
                  if regExp.match( k ) ]

         if intfs:
            hostList = []
            for intf in intfs:
               # pylint: disable-next=consider-using-f-string
               pattern = r"Vlan\d+%s" % intf
               regExp = re.compile( pattern )
               tempList = [ v for ( k, v ) in igmpHostDir.igmpHost.items() 
                  if regExp.match( k ) ]
               hostList.extend( tempList )
      else:
         hostList =  igmpHostDir.igmpHost.values()

   model = IgmpSnoopingProxyInfo()
   model.detail = detail
   regExp = re.compile( r"Vlan(\d+)(.*)")
   for host in hostList:
      match = regExp.search( host.name )
      assert match
      ( vlanStr, interface ) = match.groups()
      vlanId = int( vlanStr )

      pModel = IgmpSnoopingProxyGroups()

    
      if groupAddr :
         groupRecs = []
         if groupAddr in host.v3group :
            groupRecs.append( ( groupAddr, host.v3group[ groupAddr ] ) )
      else:
         groupRecs = host.v3group.items()
      
      for ( group, groupRecord ) in groupRecs:
         groupInfo = IgmpSnoopingProxyGroupInfo() 
         pModel.groups[ group ] = groupInfo
         if detail:
            sourceListModel = IgmpSnoopingProxySourceList()
            sourceListModel.sources = list( groupRecord.source.sourceIp )
            sourceListModel.filterMode = "Exclude" if \
                  groupRecord.filterMode == "igmpV3ModeIsExclude" else "Include"
            groupInfo.sourceList = sourceListModel

      if pModel.groups:
         if vlanId in model.vlanInfo:
            vModel = model.vlanInfo[ vlanId ]
         else:
            vModel = IgmpSnoopingProxyPorts()
            model.vlanInfo[ vlanId ] = vModel
         vModel.portInfo[ interface ] = pModel

   return model

#--------------------------------------------------------------------------------
# show ip igmp snooping groups proxy [ IP_ADDR ] [ vlan VLAN_ID ]
#                                    [ interface INTFS ] [ detail ]
#--------------------------------------------------------------------------------
class IpIgmpSnoopingGroupsProxyCmd( ShowCommand.ShowCliCommandClass ):
   syntax = ( 'show ip igmp snooping groups proxy [ IP_ADDR ] [ vlan VLAN_ID ] '
                                                  '[ interface INTFS ] [ detail ]' )
   data = {
      'ip' : CliToken.Ip.ipMatcherForShow,
      'igmp' : CliToken.IgmpSnooping.igmpNode,
      'snooping' : CliToken.IgmpSnooping.snoopingMatcher,
      'groups' : 'Show IGMP group related information',
      'proxy' : 'IGMP Snooping Proxy Information',
      'IP_ADDR' : IpAddrMatcher.ipAddrMatcher,
      'vlan' : CliToken.IgmpSnooping.vlanMatcher,
      'VLAN_ID' : IgmpSnoopingCli.vlanIdMatcher,
      'interface' : 'Interface configuration',
      'INTFS' : IntfRangeMatcher( explicitIntfTypes=( EthPhyAutoIntfType,
                                                      LagAutoIntfType ) ),
      'detail' : 'detail',
   }

   handler = doShowIpIgmpSnoopingProxyGroups
   cliModel = IgmpSnoopingProxyInfo

BasicCli.addShowCommandClass( IpIgmpSnoopingGroupsProxyCmd )
            
def Plugin( em ):
   global igmpHostDir

   igmpHostDir = LazyMount.mount( em, 'bridging/igmpsnooping/proxy/igmphost/config',
         'Igmp::IgmpHostDir', 'r' )

