# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliPlugin.TechSupportCli
from CliPlugin.IgmpSnoopingCli import igmpSnoopingSupportedGuard

# Timestamps are made up to maintain historical order within show tech-support
CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2010-01-01 00:13:00',
   cmds=[ 'show ip igmp snooping',
          'show igmp snooping querier detail',
          'show igmp snooping querier status',
          'show ip igmp snooping groups detail',
          'show ip igmp snooping counters detail',
          'show ip igmp snooping mrouter detail',
          'show configuration consistency igmp snooping' ],
   cmdsGuard=lambda: igmpSnoopingSupportedGuard( mode=None, token=None ) is None,
   summaryCmds=[ 'show igmp snooping querier' ],
   summaryCmdsGuard=lambda: igmpSnoopingSupportedGuard( mode=None, token=None )\
         is None )
