#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import ShowCommand
import Toggles.IpLockingToggleLib as ILTL
from CliPlugin.IntfCli import Intf
from CliToken.IpLocking import (
   ipLockingAddressMatcherForShow,
   ipLockingLockingMatcherForShow,
   ipLockingTableMatcherForShow,
   ipLockingIpv4MatcherForShow,
   ipLockingIpv6MatcherForShow,
   ipLockingStaticMatcherForShow,
   ipLockingDynamicMatcherForShow,
   ipLockingInterfasceMatcherForShow,
   ipLockingInstalledMatcherForShow,
   ipLockingCountersMatcherForShow,
   ipLockingServersMatcherForShow,
   ipLockingDenyMatcherForShow,
   ipLockingPermitMatcherForShow,
)

class IpLockingCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show address locking'
   data = {
      'address': ipLockingAddressMatcherForShow,
      'locking': ipLockingLockingMatcherForShow,
   }
   handler = 'IpLockingShowCommandsHandler.doShowIpLocking'
   cliModel = "IpLockingModel.IpLocking"

class IpLockingServersCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show address locking servers'
   data = {
      'address': ipLockingAddressMatcherForShow,
      'locking': ipLockingLockingMatcherForShow,
      'servers': ipLockingServersMatcherForShow,
   }
   handler = 'IpLockingShowCommandsHandler.doShowIpLockingServers'
   cliModel = "IpLockingModel.IpLockingServers"

class AddressLockingV4TableActionCmd( ShowCommand.ShowCliCommandClass ):
   syntax = ( 'show address locking table ipv4 [ static | dynamic ] '
              '[ interface INTF ] [ installed ] [ deny | permit ]' )
   data = {
      'address': ipLockingAddressMatcherForShow,
      'locking': ipLockingLockingMatcherForShow,
      'table': ipLockingTableMatcherForShow,
      'ipv4': ipLockingIpv4MatcherForShow,
      'static': ipLockingStaticMatcherForShow,
      'dynamic': ipLockingDynamicMatcherForShow,
      'interface': ipLockingInterfasceMatcherForShow,
      'INTF': Intf.matcher,
      'installed': ipLockingInstalledMatcherForShow,
      'deny': ipLockingDenyMatcherForShow,
      'permit': ipLockingPermitMatcherForShow
   }
   handler = "IpLockingShowCommandsHandler.doShowAddressLockingTable"
   cliModel = "IpLockingModel.LeasesTable"

class AddressLockingTableActionCmd( ShowCommand.ShowCliCommandClass ):
   syntax = ( 'show address locking table [ ipv4 | ipv6 ] [ static | dynamic ] '
              '[ interface INTF ] [ installed ] [ deny | permit ]' )
   data = {
      'address': ipLockingAddressMatcherForShow,
      'locking': ipLockingLockingMatcherForShow,
      'table': ipLockingTableMatcherForShow,
      'ipv4': ipLockingIpv4MatcherForShow,
      'ipv6': ipLockingIpv6MatcherForShow,
      'static': ipLockingStaticMatcherForShow,
      'dynamic': ipLockingDynamicMatcherForShow,
      'interface': ipLockingInterfasceMatcherForShow,
      'INTF': Intf.matcher,
      'installed': ipLockingInstalledMatcherForShow,
      'deny': ipLockingDenyMatcherForShow,
      'permit': ipLockingPermitMatcherForShow
   }
   handler = 'IpLockingShowCommandsHandler.doShowAddressLockingTable'
   cliModel = "IpLockingModel.LeasesTable"

class AddressLockingV4TableCmd( ShowCommand.ShowCliCommandClass ):
   syntax = ( 'show address locking table ipv4 [ static | dynamic ] '
              '[ interface INTF ] [ installed ]' )
   data = {
      'address': ipLockingAddressMatcherForShow,
      'locking': ipLockingLockingMatcherForShow,
      'table': ipLockingTableMatcherForShow,
      'ipv4': ipLockingIpv4MatcherForShow,
      'static': ipLockingStaticMatcherForShow,
      'dynamic': ipLockingDynamicMatcherForShow,
      'interface': ipLockingInterfasceMatcherForShow,
      'INTF': Intf.matcher,
      'installed': ipLockingInstalledMatcherForShow
   }
   handler = "IpLockingShowCommandsHandler.doShowAddressLockingTable"
   cliModel = "IpLockingModel.LeasesTable"

class AddressLockingTableCmd( ShowCommand.ShowCliCommandClass ):
   syntax = ( 'show address locking table [ ipv4 | ipv6 ] [ static | dynamic ] '
              '[ interface INTF ] [ installed ]' )
   data = {
      'address': ipLockingAddressMatcherForShow,
      'locking': ipLockingLockingMatcherForShow,
      'table': ipLockingTableMatcherForShow,
      'ipv4': ipLockingIpv4MatcherForShow,
      'ipv6': ipLockingIpv6MatcherForShow,
      'static': ipLockingStaticMatcherForShow,
      'dynamic': ipLockingDynamicMatcherForShow,
      'interface': ipLockingInterfasceMatcherForShow,
      'INTF': Intf.matcher,
      'installed': ipLockingInstalledMatcherForShow
   }
   handler = 'IpLockingShowCommandsHandler.doShowAddressLockingTable'
   cliModel = "IpLockingModel.LeasesTable"

class IpLockingCountersCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show address locking counters'
   data = {
      'address': ipLockingAddressMatcherForShow,
      'locking': ipLockingLockingMatcherForShow,
      'counters': ipLockingCountersMatcherForShow,
   }
   handler = 'IpLockingShowCommandsHandler.doShowIpLockingCounters'
   cliModel = "IpLockingCounterModel.IpLockingCountersModel"

BasicCli.addShowCommandClass( IpLockingCmd )
if ILTL.toggleIpLockingArIpEnabled():
   BasicCli.addShowCommandClass( AddressLockingTableActionCmd )
else:
   BasicCli.addShowCommandClass( AddressLockingV4TableActionCmd )
BasicCli.addShowCommandClass( IpLockingServersCmd )
BasicCli.addShowCommandClass( IpLockingCountersCmd )
