# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

#-----------------------------------------------------
# Register Ira show commands into "show tech-support".
#-----------------------------------------------------
from CliPlugin import TechSupportCli
from CliPlugin.IraIp6Cli import ipV6Vrf, routing4
from CliPlugin.IraNexthopGroupCli import nexthopGroupSupportedGuard
from CliPlugin.IraDlbCli import dlbEcmpSupportedGuard

# Timestamps are made up to maintain historical order within show tech-support
TechSupportCli.registerShowTechSupportCmd(
   '2010-01-01 00:06:10',
   cmds=[ 'show ip route vrf all detail',
          'show ip route vrf all host' ] )

# Timestamps are made up to maintain historical order within show tech-support
TechSupportCli.registerShowTechSupportCmd(
   '2010-01-01 00:22:00',
   cmds=[ 'show kernel ip route vrf all',
          'show kernel interface addr vrf all',
          'show kernel ip acl vrf all',
          'show kernel ip counters vrf all' ] )

TechSupportCli.registerShowTechSupportCmd(
   '2010-01-01 00:22:00',
   cmds=[ 'show kernel ipv6 counters vrf all' ],
   cmdsGuard=lambda: ipV6Vrf( mode=None, token=None ) is None )

TechSupportCli.registerShowTechSupportCmd(
   '2023-07-10 12:22:00',
   cmds=[ 'bash sudo cat /proc/slabinfo' ],
   countersCmds=[ 'bash sudo cat /proc/slabinfo' ] )

# Timestamps are made up to maintain historical order within show tech-support
TechSupportCli.registerShowTechSupportCmd(
   '2015-05-05 17:36:50',
   cmds=[ 'show nexthop-group' ],
   # Guard returns 'None' iff nexthop groups are supported on this platform.
   # NB: The "show tech-support" callbacks are executed at the time that
   #     "show tech-support" is actually executed, so the guard check is valid.
   cmdsGuard=lambda: nexthopGroupSupportedGuard( mode=None, token=None ) is None )

# Timestamps are made up to maintain historical order within show tech-support
TechSupportCli.registerShowTechSupportCmd(
   '2016-12-19 09:27:00',
   cmds=[ 'show vrf' ] )

# Timestamps are made up to maintain historical order within show tech-support
TechSupportCli.registerShowTechSupportCmd(
   '2017-04-07 09:27:00',
   cmds=[ 'show ip route vrf all summary' ],
   summaryCmds=[ 'show ip interface brief',
                 'show ip route vrf all summary' ] )

# Timestamps are made up to maintain historical order within show tech-support
TechSupportCli.registerShowTechSupportCmd(
   '2019-11-08 08:52:00',
   cmds=[ 'show kernel ip arp vrf all' ] )

# Dump the Arp/ND tables from the kernel. If V6 is not supported in non-default VRF,
# then the 'vrf' keyword will not work.
TechSupportCli.registerShowTechSupportCmd(
   '2019-11-08 08:52:00',
   cmds=[ 'show kernel ipv6 neighbors' ],
   cmdsGuard=lambda: ipV6Vrf( mode=None, token=None ) is not None )

TechSupportCli.registerShowTechSupportCmd(
   '2019-11-08 08:52:00',
   cmds=[ 'show kernel ipv6 neighbors vrf all' ],
   # The use of 'vrf all' commands (and the guard directly) causes a subtle state
   # dependence: this show tech plugin depends on IraIp6Cli.Plugin having been run
   # (ie. the CLI plugin loaded), which does not happen automatically when the module
   # is imported.
   cmdsGuard=lambda: ipV6Vrf( mode=None, token=None ) is None )

TechSupportCli.registerShowTechSupportCmd(
   '2020-06-30 18:27:13',
   summaryCmds=[ 'show vrf summary' ] )

TechSupportCli.registerShowTechSupportCmd(
   '2022-05-16 12:34:56',
   cmds=[ 'show ip route fec protocol summary' ],
   cmdsGuard=routing4.isFecModeUnified )

TechSupportCli.registerShowTechSupportCmd(
   '2023-10-12 14:32:28',
   cmds=[ 'show nexthop-group summary' ],
   summaryCmds=[ 'show nexthop-group summary' ],
   # Guard returns 'None' iff nexthop groups are supported on this platform.
   # NB: The "show tech-support" callbacks are executed at the time that
   #     "show tech-support" is actually executed, so the guard check is valid.
   cmdsGuard=lambda: nexthopGroupSupportedGuard( mode=None, token=None ) is None,
   summaryCmdsGuard=lambda: nexthopGroupSupportedGuard( mode=None,
                                                        token=None ) is None )

TechSupportCli.registerShowTechSupportCmd(
   '2024-05-05 00:10:00',
   cmds=[ 'show ip hardware fib load-balance distribution' ],
   cmdsGuard = lambda: dlbEcmpSupportedGuard( mode=None, token=None ) is None )

#--------------------------------------------------------------------------
# register show tech-support extended evpn
#--------------------------------------------------------------------------
TechSupportCli.registerShowTechSupportCmd(
   '2017-11-03 12:06:19',
   cmds=[ 'show ip route' ],
   extended='evpn' )
