# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliGlobal
from CliPlugin.RoutingIsisCli import (
      isisKw,
      isisInstanceMatcher,
      vrfKw,
      vrfNameMatcher,
      ipv6Kw,
      isisShowCommandSyntaxWrapper,
)
from CliPlugin.RoutingIsisShowSegmentRoutingCli import segmentRoutingKw
from CliPlugin import IsisSrv6ShowCliModel
import BasicCli
import ShowCommand
from Toggles import gatedToggleLib
import SharkLazyMount

gv = CliGlobal.CliGlobal( dict( isisSrv6Shark=None ) )

class ShowIsisSrv6LocatorsCmd( ShowCommand.ShowCliCommandClass ):
   syntax = isisShowCommandSyntaxWrapper( 'segment-routing ipv6 locators' )
   data = {
         'isis' : isisKw,
         'INSTANCE' : isisInstanceMatcher,
         'segment-routing' : segmentRoutingKw,
         'ipv6' : ipv6Kw,
         'locators' : 'Show locators information',
         'vrf' : vrfKw,
         'VRFNAME' : vrfNameMatcher
   }
   cliModel = IsisSrv6ShowCliModel.IsisSrv6LocatorsVRFsModel
   handler = "IsisSrv6ShowCli.ShowIsisSrv6LocatorsCmdHandler"

if gatedToggleLib.toggleIsisSrv6Enabled():
   BasicCli.addShowCommandClass( ShowIsisSrv6LocatorsCmd )

def Plugin( entityManager ):
   path = "segmentrouting/srv6/isis/default"
   shMemType = "IgpSrv6Shark::Root"
   autoUnmount = True
   if gatedToggleLib.toggleIsisSrv6Enabled():
      gv.isisSrv6Shark = SharkLazyMount.mount( entityManager, path, shMemType,
                             SharkLazyMount.mountInfo( 'shadow' ), autoUnmount )
