# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliModel import Model, Dict, Int
from ArnetModel import IpGenericPrefix
from IntfModels import Interface

#--------------------------------------------------------------------------------
# show ip route [ VRF ] kernel unprogrammed
#--------------------------------------------------------------------------------
class UnprogrammedRoute ( Model ):
   errorCode = Int( help="Standard error code" )
   interface = Interface( help="Unprogrammed route interface", optional=True )

class UnprogrammedRoutes( Model ):
   prefixes = Dict( keyType=IpGenericPrefix, valueType=UnprogrammedRoute,
                    help="A dictionary of unprogrammed route details "
                         "keyed by prefix" )

class UnprogrammedRoutesVrfs( Model ):
   vrfs = Dict( valueType=UnprogrammedRoutes,
                help="A dictionary of unprogrammed routes keyed by VRF" )
