# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

'''This file stores a series of common elements between L1 Profile CLI commands'''

from Fru.ModuleRange import (
   ModuleRangeMatcher,
)

# In order for ModuleRangeMatcher to be able to work with a restricted set of types,
# it requires some init logic from IntfRangePlugin.Module to be run first. Hence we
# import it here to trigger that logic
# pylint: disable=unused-import
from IntfRangePlugin import Module

FIXEDSYSTEM_DISPLAY_NAME = 'Switch'
SUPPORTED_MODULE_TYPES = ( 'Linecard', )

def L1ProfileSupportedModulesRangeMatcher():
   return ModuleRangeMatcher( SUPPORTED_MODULE_TYPES )

# When changing these values please ensure that the L1Profile ReloadPolicyPlugin is
# updated to handle the new token values in addition to the old ones across various
# releases.
PROFILE_NAME_NA = 'n/a'
PROFILE_STATUS_APPLIED = 'applied'
PROFILE_STATUS_ERROR = 'error'
PROFILE_STATUS_NOT_INSERTED = 'notInserted'
PROFILE_STATUS_PENDING = 'pending'

PROFILE_STATUS_RENDER_MAP = {
   PROFILE_STATUS_NOT_INSERTED: 'not inserted',
}
