# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

'''This module defines the CLI gurards used by the L1 profiles CLI.'''

from TypeFuture import TacLazyType
import Cell
import CliGlobal
import CliParser
import LazyMount

ProductConfig = TacLazyType( 'L1Profile::ProductConfig' )
MountConstants = TacLazyType( 'L1Profile::MountConstants' )

gv = CliGlobal.CliGlobal( dict( productConfig=None, ) )

def l1ProfileEnabledGuard( mode, token ):
   if not gv.productConfig.enabled:
      return CliParser.guardNotThisPlatform

   return None

def modularSystemGuard( mode, token ):
   if not gv.productConfig.enabled:
      return CliParser.guardNotThisPlatform

   if Cell.cellType() == 'fixed':
      return CliParser.guardNotThisPlatform

   return None

def fixedSystemGuard( mode, token ):
   if not gv.productConfig.enabled:
      return CliParser.guardNotThisPlatform

   if Cell.cellType() != 'fixed':
      return CliParser.guardNotThisPlatform

   return None

def Plugin( entityManager ):
   gv.productConfig = LazyMount.mount(
      entityManager,
      MountConstants.productConfigPath(),
      ProductConfig.tacType.fullTypeName,
      'r' )
