# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
import CliGlobal
import CliMatcher
from CliPlugin.SystemL1 import SystemL1ConfigMode, registerCleanupHook
import ConfigMount
import Tac

gv = CliGlobal.CliGlobal( dict( ethPhyIntfDefaultConfigDir=None ) )

def getXcvrCapabilitiesVerificationBypassAttrName( capType ):
   capTypeToAttrNameMap = {
      'speed': 'speed',
      'error-correction': 'errorCorrection' }
   return capTypeToAttrNameMap[ capType ]

class SystemL1UnsupportedActionCmd( CliCommand.CliCommandClass ):
   syntax = 'unsupported CAPABILITY action ACTION'
   noOrDefaultSyntax = 'unsupported CAPABILITY action [ ACTION ]'
   data = {
      'unsupported': 'Configuration for handling unsupported'
                     ' L1 interface configurations',
      'CAPABILITY': CliMatcher.EnumMatcher( {
         'speed': 'Speed/duplex',
         'error-correction': 'Forward error correction' } ),
      'action': 'Configure the action to take on an unsupported configuration',
      'ACTION': CliMatcher.EnumMatcher( {
         'warn': 'Generate warning message prompt',
         'error': 'Prevent configuration with an error message' } )
   }

   @staticmethod
   def handler( mode, args ):
      capType = args[ 'CAPABILITY' ]
      attrName = getXcvrCapabilitiesVerificationBypassAttrName( capType )
      actionType = args[ 'ACTION' ]
      bypassVal = Tac.nonConst(
         gv.ethPhyIntfDefaultConfigDir.xcvrCapVerificationBypass )
      if actionType == "warn":
         setattr( bypassVal, attrName, True )
      else:
         assert actionType == 'error'
         setattr( bypassVal, attrName, False )
      gv.ethPhyIntfDefaultConfigDir.xcvrCapVerificationBypass = bypassVal

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      capType = args[ 'CAPABILITY' ]
      attrName = getXcvrCapabilitiesVerificationBypassAttrName( capType )
      bypassVal = Tac.nonConst(
         gv.ethPhyIntfDefaultConfigDir.xcvrCapVerificationBypass )
      setattr( bypassVal, attrName, False )
      gv.ethPhyIntfDefaultConfigDir.xcvrCapVerificationBypass = bypassVal

def unsupportedCapActionCleanup():
   gv.ethPhyIntfDefaultConfigDir.xcvrCapVerificationBypass = Tac.Value(
         "Interface::XcvrCapabilitiesVerificationBypass" )

SystemL1ConfigMode.addCommandClass( SystemL1UnsupportedActionCmd )
registerCleanupHook( 'L1 Unsupported', unsupportedCapActionCleanup )

def Plugin( em ):
   gv.ethPhyIntfDefaultConfigDir = ConfigMount.mount(
         em, "interface/config/eth/phy/globalDefault",
         "Interface::EthPhyIntfGlobalDefaultConfigDir", "w" )
