# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCliModes
import ConfigMount
import CliCommand
from CliPlugin.LagCommonCliLib import (
      distributionMatcherForConfig,
)
from CliToken.LoadBalance import (
      loadBalanceMatcherForConfig,
)
from CliToken.PortChannel import (
      portChannelMatcherForConfig,
)

dlbLagConfig = None

# --------------------------------------------------------------------------------
# [ no | default ] port-channel load-balance distribution ( hash | dynamic )
# --------------------------------------------------------------------------------
class PortChannelLoadBalanceDistCmd( CliCommand.CliCommandClass ):
   syntax = 'port-channel load-balance distribution ( hash | dynamic )'
   noOrDefaultSyntax = 'port-channel load-balance distribution ...'
   data = {
      'port-channel': portChannelMatcherForConfig,
      'load-balance': loadBalanceMatcherForConfig,
      'distribution': distributionMatcherForConfig,
      'hash': 'Enable hash based load balancing',
      'dynamic': 'Enable dynamic load balancing'
   }

   @staticmethod
   def handler( mode, args ):
      dlbLagConfig.globalDlbLagEnable = 'dynamic' in args

   noOrDefaultHandler = handler

BasicCliModes.GlobalConfigMode.addCommandClass( PortChannelLoadBalanceDistCmd )

# -------------------------------------------------------------------------------
# Have the Cli Agent mount all needed state from sysdb
# -------------------------------------------------------------------------------
def Plugin( entityManager ):
   global dlbLagConfig

   dlbLagConfig = ConfigMount.mount( entityManager, "lag/hardware/dlb/config",
                                     "Lag::Hardware::DlbConfig", "w" )
