# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliPlugin.MaintenanceCliLib import isSubIntf

def addIntf( mode, args ):
   intfs = args.get( 'INTERFACE' )
   if isSubIntf( str( intfs ) ):
      mode.addError( "Sub-interface config is not supported" )
      return
   mode.group().addIntf( intfs )

def remIntf( mode, args ):
   intfs = args.get( 'INTERFACE' )
   if isSubIntf( str( intfs ) ):
      mode.addError( "Sub-interface config is not supported" )
      return
   mode.group().remIntf( intfs )

