#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
# pylint: disable-next=consider-using-from-import
import CliPlugin.LagGroupCli as LagGroupCli
# pylint: disable-next=consider-using-from-import
import CliPlugin.LagIntfCli as LagIntfCli
import CliPlugin
from Intf.IntfRange import IntfRangeMatcher

#--------------------------------------------------------------------------------
# [ no | default ] interface INTERFACE
#--------------------------------------------------------------------------------
class InterfaceCmd( CliCommand.CliCommandClass ):
   syntax = 'interface INTERFACE'
   noOrDefaultSyntax = syntax
   data = {
      'interface': 'Configure member',
      'INTERFACE': IntfRangeMatcher( 
         explicitIntfTypes={ LagIntfCli.LagAutoIntfType } ),
   }
   handler = LagGroupCli.addIntf
   noOrDefaultHandler = LagGroupCli.remIntf

CliPlugin.IntfGroupLib.IntfGroupConfigMode.addCommandClass( InterfaceCmd )
