#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

#-------------------------------------------------------------------------------
# This module implements the following commands:
#-------------------------------------------------------------------------------
# clear loop-protection counters
#--------------------------------------------------------------------------------

# pylint: disable=ungrouped-imports

import BasicCliModes
import CliCommand
from CliToken.Clear import clearKwNode

#--------------------------------------------------------------------------------
# clear loop-protection counters
#--------------------------------------------------------------------------------

class ClearLoopProtectionCountersCmd( CliCommand.CliCommandClass ):
   syntax = 'clear loop-protection counters'
   data = {
      'clear': clearKwNode,
      'loop-protection': 'Loop Protection status',
      'counters': 'Counters for loop protection messages',
   }
   
   handler = "LoopProtectEnableModeHandler.clearCounters"

BasicCliModes.EnableMode.addCommandClass( ClearLoopProtectionCountersCmd )
