#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

#-------------------------------------------------------------------------------
# This module implements the following commands:
#-------------------------------------------------------------------------------
# - [ no ] monitor loop-protection
#-------------------------------------------------------------------------------

# pylint: disable=ungrouped-imports

import BasicCliModes
import CliParser
import CliCommand
import LazyMount
# pylint: disable-next=consider-using-from-import
from CliToken.Monitor import monitorMatcher

bridgingHwCapabilities = None

#--------------------------------------------------------------------------------
# [ no | default ] monitor loop-protection
#--------------------------------------------------------------------------------
def loopProtectSupportedGuard( mode, token ):
   if bridgingHwCapabilities.loopProtectSupported:
      return None
   return CliParser.guardNotThisPlatform

class MonitorLoopProtectionCmd( CliCommand.CliCommandClass ):
   syntax = 'monitor loop-protection'
   noOrDefaultSyntax = syntax
   data = {
      'monitor': monitorMatcher,
      'loop-protection': CliCommand.guardedKeyword( 'loop-protection', 
         helpdesc='Monitor Loop Protection Configuration', 
         guard=loopProtectSupportedGuard ),
   }
   
   handler = "LoopProtectGlobalConfigModeHandler.gotoMonitorLoopProtectMode"
   noOrDefaultHandler = "LoopProtectGlobalConfigModeHandler.noMonitorLoopProtect"

BasicCliModes.GlobalConfigMode.addCommandClass( MonitorLoopProtectionCmd )

def Plugin( entityManager ):
   global bridgingHwCapabilities
   bridgingHwCapabilities = LazyMount.mount( entityManager,
                                             'bridging/hwcapabilities',
                                             'Bridging::HwCapabilities', 'r' )
