#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCliModes
import CliCommand
import CliMatcher
import CliPlugin.MacFlapCliHelpers as MacFlapCliHelpers
from CliPlugin.BridgingCli import MacAddrTableExprForConfig

matcherDetection = CliMatcher.KeywordMatcher( 'detection',
      helpdesc='Fine grained detection settings' )
matcherHostFlap = CliMatcher.KeywordMatcher( 'host-flap',
      helpdesc='MAC address interface flapping' )
matcherMoves = CliMatcher.KeywordMatcher( 'moves',
      helpdesc='The number of MAC moves needed to count as a flap' )
matcherNotification = CliMatcher.KeywordMatcher( 'notification',
      helpdesc='Options for notification' )
matcherWindow = CliMatcher.KeywordMatcher( 'window',
      helpdesc='Size of the detection time window (in seconds)' )

hostFlapBaseSyntax = 'MAC_ADDR_TABLE notification host-flap detection moves'
hostFlapWindowBaseSyntax = 'MAC_ADDR_TABLE notification host-flap detection window'

#--------------------------------------------------------------------------------
# ( ( mac address-table ) | mac-address-table )
#       notification host-flap detection moves MOVES
#--------------------------------------------------------------------------------
class HostFlapDetectionMovesCmd( CliCommand.CliCommandClass ):
   syntax = hostFlapBaseSyntax + ' MOVES'
   noOrDefaultSyntax = hostFlapBaseSyntax + ' ...'
   data = {
      'MAC_ADDR_TABLE': MacAddrTableExprForConfig,
      'notification': matcherNotification,
      'host-flap': matcherHostFlap,
      'detection': matcherDetection,
      'moves': matcherMoves,
      'MOVES': CliMatcher.IntegerMatcher( 2, 10,
                 helpdesc='The number of MAC moves needed to count as a flap' ),
   }
   handler = MacFlapCliHelpers.doSetMacFlapMoves
   noOrDefaultHandler = MacFlapCliHelpers.doSetMacFlapMoves

BasicCliModes.GlobalConfigMode.addCommandClass( HostFlapDetectionMovesCmd )

#--------------------------------------------------------------------------------
# ( ( mac address-table ) | mac-address-table )
#       notification host-flap detection window WINDOW
#--------------------------------------------------------------------------------
class HostFlapDetectionWindowCmd( CliCommand.CliCommandClass ):
   syntax = hostFlapWindowBaseSyntax + ' WINDOW'
   noOrDefaultSyntax = hostFlapWindowBaseSyntax + ' ...'
   data = {
      'MAC_ADDR_TABLE': MacAddrTableExprForConfig,
      'notification': matcherNotification,
      'host-flap': matcherHostFlap,
      'detection': matcherDetection,
      'window': matcherWindow,
      'WINDOW': CliMatcher.IntegerMatcher( 2, 300,
                  helpdesc='Size of the detection time window (in seconds)' ),
   }
   handler = MacFlapCliHelpers.doSetMacFlapDetectionWindow
   noOrDefaultHandler = MacFlapCliHelpers.doSetMacFlapDetectionWindow

BasicCliModes.GlobalConfigMode.addCommandClass( HostFlapDetectionWindowCmd )

#--------------------------------------------------------------------------------
# ( ( mac address-table ) | mac-address-table ) notification host-flap logging
#--------------------------------------------------------------------------------
class NotificationHostFlapLoggingCmd( CliCommand.CliCommandClass ):
   syntax = 'MAC_ADDR_TABLE notification host-flap logging'
   noSyntax = syntax + ' ...'
   defaultSyntax = noSyntax
   data = {
      'MAC_ADDR_TABLE': MacAddrTableExprForConfig,
      'notification': matcherNotification,
      'host-flap': matcherHostFlap,
      'logging': 'Log occurrences of this event',
   }
   handler = MacFlapCliHelpers.doSetMacFlapStatus
   defaultHandler = handler
   noHandler = MacFlapCliHelpers.noSetMacFlapStatus

BasicCliModes.GlobalConfigMode.addCommandClass( NotificationHostFlapLoggingCmd )
