# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliPlugin.MacFlapCliHelpers import MacFlapStatus, MacFlapDetectionWindow
from CliPlugin.BridgingCli import MacAddrTableExprForShow
import CliPlugin.MacFlapCliHelpers as MacFlapCliHelpers
import BasicCli
import CliMatcher
import ShowCommand

matcherHostFlap = CliMatcher.KeywordMatcher( 'host-flap',
      helpdesc='MAC address interface flapping' )
matcherNotification = CliMatcher.KeywordMatcher( 'notification',
      helpdesc='Options for notification' )
#--------------------------------------------------------------------------------
# show ( ( mac address-table ) | mac-address-table )
#       notification host-flap detection window
#--------------------------------------------------------------------------------

class NotificationHostFlapDetectionWindowCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show MAC_ADDR_TABLE notification host-flap detection window'
   data = {
      'MAC_ADDR_TABLE': MacAddrTableExprForShow,
      'notification': matcherNotification,
      'host-flap': matcherHostFlap,
      'detection': 'Fine grained detection settings',
      'window': 'Size of the detection time window (in seconds)',
   }
   handler = MacFlapCliHelpers.doShowMacFlapDetectWindow
   cliModel = MacFlapDetectionWindow
   hidden = True

BasicCli.addShowCommandClass( NotificationHostFlapDetectionWindowCmd )

#--------------------------------------------------------------------------------
# show ( ( mac address-table ) | mac-address-table ) notification host-flap logging
#--------------------------------------------------------------------------------
class NotificationHostFlapLoggingCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show MAC_ADDR_TABLE notification host-flap logging'
   data = {
      'MAC_ADDR_TABLE': MacAddrTableExprForShow,
      'notification': matcherNotification,
      'host-flap': matcherHostFlap,
      'logging': 'Log occurrences of this event',
   }
   handler = MacFlapCliHelpers.doShowMacFlapStatus
   cliModel = MacFlapStatus
   hidden = True

BasicCli.addShowCommandClass( NotificationHostFlapLoggingCmd )
