# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
import CliGlobal
import CliParser
import CliPlugin.VlanCli as VlanCli # pylint: disable=consider-using-from-import
import LazyMount
import Tac

gv = CliGlobal.CliGlobal( bridgingHwCapabilities=None )

#-------------------------------------------------------------------------------
# The "[no] switchport mac address learning" command, in "config-if" mode.
#
# The full syntax of this command is:
#
#   no switchport mac address learning
#   [default] switchport mac address learning
#-------------------------------------------------------------------------------
def noMacLearningSupportedGuard( mode, token ):
   if gv.bridgingHwCapabilities.noMacLearningSupported:
      return None
   return CliParser.guardNotThisPlatform

def setMacLearning( mode, learning ):
   sic = VlanCli.getSwitchIntfConfigEvenIfDisabled( mode )
   sic.macLearningEnabled = learning

def enableMacLearning( mode, args ):
   setMacLearning( mode, True )

def disableMacLearning( mode, args ):
   setMacLearning( mode, False )

class MacLearningCmd( CliCommand.CliCommandClass ):
   syntax = 'switchport mac address learning'
   noOrDefaultSyntax = syntax
   data = {
      'switchport' : VlanCli.switchportMatcher,
      'mac': CliCommand.guardedKeyword( 'mac',
                helpdesc='Configure MAC learning on this interface',
                guard=noMacLearningSupportedGuard ),
      'address' : 'Address keyword',
      'learning' : 'Learning keyword',
      }

   handler = enableMacLearning
   defaultHandler = enableMacLearning
   noHandler = disableMacLearning

VlanCli.SwitchportModelet.addCommandClass( MacLearningCmd ) 

def Plugin( entityManager ):
   gv.bridgingHwCapabilities = LazyMount.mount( entityManager,
                                     "bridging/hwcapabilities",
                                     "Bridging::HwCapabilities", "r" )
