# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliPlugin.MacLimitPerVlanCliModel import MacLimitPerVlanTable
from CliPlugin.VlanCli import vlanSetMatcher
from CliPlugin.BridgingCli import MacAddrTableExprForShow
import ShowCommand
import LazyMount
import BasicCli

bridgingConfig = None
vlanLearnLimitStatusCol = None

def doShowMacLimitPerVlanTable( mode, args ):
   def limitedVlanEntryFactory( limit, currentAddresses, appliedLimit ):
      entry = MacLimitPerVlanTable.LimitedVlanEntry()
      entry.limit = limit
      entry.currentAddresses = currentAddresses
      entry.appliedLimit = appliedLimit
      return entry

   table = MacLimitPerVlanTable()
   vlanSet = args.get( "VLAN_SET", [] )

   for vlan in bridgingConfig.vlanConfig:
      limit = bridgingConfig.vlanConfig[ vlan ].maxLearnedDynamicMac

      if limit > 0 and ( vlan in vlanSet or not vlanSet ):
         if vlan in vlanLearnLimitStatusCol.status:
            vlanLearnLimitStatus = vlanLearnLimitStatusCol.status[ vlan ]
            currentAddresses = vlanLearnLimitStatus.macCount
            entry = limitedVlanEntryFactory( limit, currentAddresses,
                                             vlanLearnLimitStatus.appliedLimit )
         else:
            entry = limitedVlanEntryFactory( limit, 0, -1 )
         table.limitedVlans[ vlan ] = entry

   return table

class MacAddrTableDynamicLocalLimitCmd( ShowCommand.ShowCliCommandClass ):
   syntax = "show MAC_ADDR_TABLE dynamic local limit [ vlan VLAN_SET ]"
   data = {
      'MAC_ADDR_TABLE': MacAddrTableExprForShow,
      'dynamic': 'Dynamic entry type',
      'local': 'Local mac address learning property of VLANs',
      'limit': 'Limit on locally learned dynamic MAC addresses on VLANs',
      'vlan': 'Specify VLANs to show limits for',
      'VLAN_SET': vlanSetMatcher,
   }
   cliModel = MacLimitPerVlanTable
   handler = doShowMacLimitPerVlanTable

BasicCli.addShowCommandClass( MacAddrTableDynamicLocalLimitCmd )

def Plugin( em ):
   global bridgingConfig, vlanLearnLimitStatusCol
   bridgingConfig = LazyMount.mount( em, 'bridging/config',
                                    'Bridging::Config', 'r' )
   vlanLearnLimitStatusCol = LazyMount.mount( em,
                              'bridging/vlan/learnlimitstatus',
                              'Ebra::VlanLearnLimitStatusCollection', 'r' )
