# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import CliCommand
import CliMatcher
import CliParser
import BasicCli
import ConfigMount
import LazyMount

cliConfig = None
bridingHwCapabilities = None

def macMulticastSupportedGuard( mode, token ):
   if bridingHwCapabilities.macIpv4McMismatchDropSupported:
      return None
   return CliParser.guardNotThisPlatform

# -----------------------------------------------------------------------------------
# Cli Plugin for following command:
# mac multicast destination-check ipv4 unicast action {forward | drop}
# -----------------------------------------------------------------------------------
class MacMulticastDestinationCmd( CliCommand.CliCommandClass ):
   syntax = "mac multicast destination-check ipv4 unicast action ( forward | drop )"
   data = {
      "mac": "Global MAC configuration commands",
      "multicast": CliCommand.Node( CliMatcher.KeywordMatcher( "multicast",
                                                                helpdesc="Configure "
                                                                         "Multicast"
                                                               ),
                                    guard=macMulticastSupportedGuard ),
      "destination-check": "Configure Destination Checks",
      "ipv4": "Configure IPv4",
      "unicast": "Configure Unicast",
      "action": "Configure Action",
      "forward": "Forward Packets",
      "drop": "Drop Packets"
   }

   @staticmethod
   def handler( mode, args ):
      if "forward" in args:
         cliConfig.macIpv4McMismatchDropEnabled = False
      elif "drop" in args:
         cliConfig.macIpv4McMismatchDropEnabled = True


BasicCli.GlobalConfigMode.addCommandClass( MacMulticastDestinationCmd )


def Plugin( entityManager ):
   global cliConfig
   global bridingHwCapabilities
   cliConfig = ConfigMount.mount( entityManager, "bridging/input/config/cli",
                                  "Bridging::Input::CliConfig", "w" )
   bridingHwCapabilities = LazyMount.mount( entityManager,
                                            "bridging/hwcapabilities",
                                            "Bridging::HwCapabilities", "r" )
