#!/usr/bin/env python3
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliGlobal
from CliMode.MaintenanceUnitMode import MaintenanceUnitMode
from CliMode.MaintenanceMode import MaintenanceMode
from CliMode.MaintenanceUnitProfileMode import MaintenanceUnitProfileMode
from CliMode.MaintenanceBuiltinUnitMode import MaintenanceBuiltinUnitMode
from CliMode.MaintenanceStagesMode import MaintenanceStagesMode
from CliMode.PimMaintenanceMode import PimMaintenanceMode
from CliMode.PimsmMaintenanceMode import PimsmMaintenanceMode
import ConfigMount
import LazyMount
import Tac
from Toggles.MaintenanceToggleLib import toggleMaintModeOnBootLinkDisableEnabled

gv = CliGlobal.CliGlobal( onBootLinkEnableOverrideConfig=None,
                          startupConfigStatus=None )

class MaintenanceUnitConfigMode( MaintenanceUnitMode, BasicCli.ConfigModeBase ):
   name = "Maintenance unit configuration"

   def __init__( self, parent, session, maintenanceUnit ):
      self.maintenanceUnit_ = maintenanceUnit
      self.session_ = session
      MaintenanceUnitMode.__init__( self, self.maintenanceUnit_.name() )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

class MaintenanceConfigMode( MaintenanceMode, BasicCli.ConfigModeBase ):
   name = "MaintenanceMode configuration"

   def __init__( self, parent, session ):
      self.session_ = session
      MaintenanceMode.__init__( self, None )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

   def onExit( self ):
      BasicCli.ConfigModeBase.onExit( self )

      # Only create override config during startup config processing
      if ( toggleMaintModeOnBootLinkDisableEnabled() and
           gv.startupConfigStatus.startupConfigStatus == "inProgress" and
           "MaintenanceMode" not in gv.onBootLinkEnableOverrideConfig.feature ):
         overrideConfig = Tac.newInstance(
                             "Interface::OnBootLinkEnableOverrideFeature",
                             "MaintenanceMode" )
         overrideConfig.time = Tac.now()
         overrideConfig.agents.add( "MaintenanceMode" )
         gv.onBootLinkEnableOverrideConfig.addFeature( overrideConfig )

class MaintenanceUnitProfileConfigMode( MaintenanceUnitProfileMode,
                                        BasicCli.ConfigModeBase ):
   name = "Maintenance Unit profile configuration"

   def __init__( self, parent, session, unitProfile ):
      self.unitProfile_ = unitProfile
      self.session_ = session
      MaintenanceUnitProfileMode.__init__( self, self.unitProfile_.name() )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

class MaintenanceBuiltinUnitConfigMode( MaintenanceBuiltinUnitMode,
                                        BasicCli.ConfigModeBase ):
   name = "Maintenance builtin Unit Configuration"

   def __init__( self, parent, session, builtinUnit, unitObject=None ):
      self.builtinUnit_ = builtinUnit
      self.session_ = session
      self.unitObject_ = unitObject
      MaintenanceBuiltinUnitMode.__init__( self, self.builtinUnit_ )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

class MaintenanceStagesConfigMode( MaintenanceStagesMode,
                                   BasicCli.ConfigModeBase ):
   name = "Maintenance stages configuration"

   def __init__( self, parent, session ):
      self.session_ = session
      MaintenanceStagesMode.__init__( self, None )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

class PimMaintenanceConfigMode( PimMaintenanceMode,
                                BasicCli.ConfigModeBase ):
   name = "PIM stages configuration"

   def __init__( self, parent, session ):
      self.session_ = session
      PimMaintenanceMode.__init__( self, None )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

class PimsmMaintenanceConfigMode( PimsmMaintenanceMode,
                                  BasicCli.ConfigModeBase ):
   name = "PIM sparse mode maintenance configuration"

   def __init__( self, parent, session ):
      self.session_ = session
      PimsmMaintenanceMode.__init__( self, None )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

def Plugin( entityManager ):
   if toggleMaintModeOnBootLinkDisableEnabled():
      gv.onBootLinkEnableOverrideConfig = ConfigMount.mount(
         entityManager, 'interface/shutdown/onboot/config',
         'Interface::OnBootLinkEnableOverrideConfig', 'w' )
      gv.startupConfigStatus = LazyMount.mount(
         entityManager, 'Sysdb/status', 'Sysdb::Status', 'r' )
