#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Cell
import BasicCli
import ShowCommand
# pylint: disable-next=consider-using-from-import
import CliPlugin.ManagementActiveIntfCli as ManagementActiveIntfCli
from CliPlugin.VirtualIntfRule import VirtualIntfMatcher
from CliPlugin.ManagementActiveIntfModel import MgmtActiveIntfRedundancyStatus
import CliToken.Redundancy as Redundancy # pylint: disable=consider-using-from-import

#--------------------------------------------------------------------------------
# show redundancy backup-link
#--------------------------------------------------------------------------------
class RedundancyBackupLinkCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show redundancy ( backup-link | MGMT_INTF )'
   data = {
      'redundancy': Redundancy.redundancyForShowGuarded,
      'backup-link': 'Management0 backup link details',
      'MGMT_INTF': VirtualIntfMatcher( 'Management', 0, 0 )
   }
   handler = ManagementActiveIntfCli.doShowRedBackupLink
   cliModel = MgmtActiveIntfRedundancyStatus

if Cell.cellType() == 'supervisor':
   BasicCli.addShowCommandClass( RedundancyBackupLinkCmd )
