#!/usr/bin/env python3
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
from CliPlugin import IntfCli
from CliPlugin.RouterMulticastCliLib import AddressFamily
from CliPlugin.RouterMulticastCliLib import doConfigMounts, getConfigRoot
import ConfigMount

StaticMrouteConfigColl = "McastCommon::StaticMrouteConfigColl"
mcastHostInject4Config = None
mcastHostInject6Config = None

class McastCommonIntf( IntfCli.IntfDependentBase ):
   ''' The McastCommonIntf class is used to remove the McastStatic IntfConfig
   object when an interface is deleted.  The Intf class will create a new
   instance of McastCommonIntf and call destroy when the interface is deleted. '''
   def setDefault( self ):
      ''' Destroys the IntfConfig object for this interface if the
          object exists. '''
      name = self.intf_.name
      for af in [ AddressFamily.ipv4, AddressFamily.ipv6 ]:
         config = getConfigRoot( af, configType=StaticMrouteConfigColl )
         del config.intfConfig[ name ]
      cKey = Tac.newInstance( "HostInject::DefaultConfigKey", name )
      del mcastHostInject4Config.config[ cKey ]
      del mcastHostInject6Config.config[ cKey ]

def Plugin( entityManager ):
   global mcastHostInject4Config
   global mcastHostInject6Config

   configTypes = [ StaticMrouteConfigColl ]
   doConfigMounts( entityManager, configTypes )

   mcastHostInject4Config = ConfigMount.mount(
         entityManager, 'routing/attached-host/mcast/config',
         'HostInject::HostInjectConfig', 'w' )
   mcastHostInject6Config = ConfigMount.mount(
         entityManager, 'routing6/attached-host/mcast/config',
         'HostInject::HostInjectConfig', 'w' )

   IntfCli.Intf.registerDependentClass( McastCommonIntf, priority=21 )
