# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliModel import List, Model, Str
from TableOutput import createTable, Format

class MeasuredBootVersion( Model ):
   name = Str( help="Name of the measured boot component" )
   version = Str( help="Version of the measured boot component" )

class MeasuredBootVersionList( Model ):
   versions = List( valueType=MeasuredBootVersion,
                    help="Measured boot versions" )

   def render( self ):
      table = createTable( ( "Component", "Version" ) )
      headerFormat = Format( justify="left", noBreak=True )
      headerFormat.noPadLeftIs( True )
      versionFormat = Format( justify="right", noBreak=True )
      table.formatColumns( headerFormat, versionFormat )

      for version in self.versions:
         table.newRow( version.name, version.version )

      print( table.output() )
