# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import Tac
from CliMode.MgmtGnmiClient import (
   MgmtGnmiClientBaseMode,
   GnmiServerBaseMode,
   GnmiServerGroupBaseMode
)

class MgmtGnmiClientMode( MgmtGnmiClientBaseMode, BasicCli.ConfigModeBase ):
   name = 'Configure the switch as an gNMI client'

   def __init__( self, parent, session ):
      MgmtGnmiClientBaseMode.__init__( self, 'client-api-gnmi' )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

class GnmiServerMode( GnmiServerBaseMode, BasicCli.ConfigModeBase ):
   name = 'Configure gNMI server'

   def __init__( self, parent, session, gnmiServerName, config ):
      self.gnmiServerName = gnmiServerName
      self.config = config
      GnmiServerBaseMode.__init__( self, self.gnmiServerName )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

   def gnmiServer( self ):
      return self.config.gnmiServer[ self.gnmiServerName ]

   def modifyUsernamePassword( self, username, password ):
      existingServer = self.gnmiServer()
      gnmiServer = Tac.Value( 'MgmtGnmiClient::GnmiServer', existingServer.name,
                               existingServer.hostname, existingServer.vrf,
                               existingServer.port, username, password )
      self.config.gnmiServer.addMember( gnmiServer )

   def modifyAddressVrfPort( self, hostname, vrf, port ):
      existingServer = self.gnmiServer()
      gnmiServer = Tac.Value( 'MgmtGnmiClient::GnmiServer', existingServer.name,
                               hostname, vrf, port, existingServer.username,
                               existingServer.password )
      self.config.gnmiServer.addMember( gnmiServer )

class GnmiServerGroupMode( GnmiServerGroupBaseMode, BasicCli.ConfigModeBase ):
   name = 'Configure gNMI server group'

   def __init__( self, parent, session, gnmiServerGroupName, config ):
      self.gnmiServerGroupName = gnmiServerGroupName
      self.config = config
      GnmiServerGroupBaseMode.__init__( self, self.gnmiServerGroupName )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

   def getServerGroup( self ):
      return self.config.gnmiServerGroup[ self.gnmiServerGroupName ]

   def addGnmiServer( self, gnmiServerName ):
      gnmiServerGroup = self.getServerGroup()
      gnmiServerGroup.memberGnmiServer.add( gnmiServerName )

   def removeGnmiServer( self, gnmiServerName ):
      gnmiServerGroup = self.getServerGroup()
      del gnmiServerGroup.memberGnmiServer[ gnmiServerName ]
