#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliCommand
from CliPlugin import ConfigMgmtMode
# the following is necessary to register AAA group
import LdapGroup # pylint: disable=unused-import

#-------------------------------------------
#  (config)#[ no | default ] management ldap
#-------------------------------------------
class EnterLdapConfigMode( CliCommand.CliCommandClass ):
   syntax = """management ldap"""
   noOrDefaultSyntax = syntax

   data = { "management": ConfigMgmtMode.managementKwMatcher,
            "ldap": 'Configure LDAP options for AAA' }
   handler = "LdapHandler.enterMgmtLdapMode"
   noOrDefaultHandler = "LdapHandler.noMgmtLdapMode"

BasicCli.GlobalConfigMode.addCommandClass( EnterLdapConfigMode )
