#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from BasicCli import addShowCommandClass
from CliToken.Flow import flowMatcherForShow
from CliPlugin.FlowTrackingCliLib import (
   mirrorOnDropShowKw,
   trackerKw,
   countersKw,
   exporterKw,
   exporterNameMatcher,
   interfaceKw,
   mirrorOnDropFlowTableShowKw,
   mirrorOnDropCountersShowKw,
   trackingShowKw,
   trackerNameMatcher,
   dropReasonKw,
)
from CliPlugin import IntfCli
import ShowCommand

class ShowModFlowTable( ShowCommand.ShowCliCommandClass ):
   syntax = 'show flow tracking mirror-on-drop flow-table'\
            '[ tracker TRACKER_NAME ]'
   data = {
      'flow': flowMatcherForShow,
      'tracking': trackingShowKw,
      'mirror-on-drop': mirrorOnDropShowKw,
      'flow-table': mirrorOnDropFlowTableShowKw,
      'tracker': trackerKw,
      'TRACKER_NAME': trackerNameMatcher,
   }

   handler = "MirrorOnDropCliShowHandlers.showFlowTable"
   cliModel = "MirrorOnDropModel.ModShowModel"

addShowCommandClass( ShowModFlowTable )

class ShowModCounters( ShowCommand.ShowCliCommandClass ):
   syntax = 'show flow tracking mirror-on-drop counters '\
      '[ tracker TRACKER_NAME [ interface | ( exporter EXPORTER_NAME ) ] ]'
   data = {
      'flow': flowMatcherForShow,
      'tracking': trackingShowKw,
      'mirror-on-drop': mirrorOnDropShowKw,
      'counters': mirrorOnDropCountersShowKw,
      'tracker': trackerKw,
      'TRACKER_NAME': trackerNameMatcher,
      'interface': interfaceKw,
      'exporter': exporterKw,
      'EXPORTER_NAME': exporterNameMatcher
   }

   handler = "MirrorOnDropCliShowHandlers.showCounters"
   cliModel = "MirrorOnDropModel.ModShowModel"

addShowCommandClass( ShowModCounters )

class ShowModCountersDropReason( ShowCommand.ShowCliCommandClass ):
   syntax = 'show flow tracking mirror-on-drop counters drop-reason '\
      '[ tracker TRACKER_NAME [ interface INTERFACE_NAME ] ]'

   data = {
      'flow': flowMatcherForShow,
      'tracking': trackingShowKw,
      'mirror-on-drop': mirrorOnDropShowKw,
      'counters': countersKw,
      'drop-reason': dropReasonKw,
      'tracker': trackerKw,
      'TRACKER_NAME': trackerNameMatcher,
      'interface': interfaceKw,
      'INTERFACE_NAME': IntfCli.Intf.matcher
   }

   handler = "MirrorOnDropCliShowHandlers.showDropReasonCounters"
   cliModel = "MirrorOnDropModel.ModShowModel"

addShowCommandClass( ShowModCountersDropReason )
