#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import time
from CliPlugin import TechSupportCli
import AgentDirectory
import LazyMount
from TypeFuture import TacLazyType

modCapabilities = None
entityManager = None

ExportFormat = TacLazyType( 'FlowTracking::ExportFormat' )

def _mirrorOnDropShowTechGuard():
   return ( modCapabilities.supported and
           ( AgentDirectory.agent( entityManager.sysname(),
                                   'StrataMirror' ) or
             AgentDirectory.agent( entityManager.sysname(),
                                   'DropExport' ) ) )

def _modDropReasonShowTechGuard():
   return ( modCapabilities.supported and
            ExportFormat.formatSflow in modCapabilities.exportFormatHwSupported and
            AgentDirectory.agent( entityManager.sysname(),
                                  'DropExport' ) )

SHOW_TECH_MIRROR_ON_DROP_CMDS = [
    'show flow tracking mirror-on-drop'
]

SHOW_TECH_MOD_DROP_REASON_CMDS = [
    'show flow tracking mirror-on-drop counters drop-reason'
]

TIMESTAMP = time.strftime( '%Y-%m-%d %H:%M:%S' )

TechSupportCli.registerShowTechSupportCmd(
    TIMESTAMP,
    cmds=SHOW_TECH_MIRROR_ON_DROP_CMDS,
    cmdsGuard=_mirrorOnDropShowTechGuard
)

TIMESTAMP = time.strftime( '%Y-%m-%d %H:%M:%S' )

TechSupportCli.registerShowTechSupportCmd(
    TIMESTAMP,
    cmds=SHOW_TECH_MOD_DROP_REASON_CMDS,
    cmdsGuard=_modDropReasonShowTechGuard
)

def Plugin( em ):
   global modCapabilities
   global entityManager
   entityManager = em
   modCapabilities = LazyMount.mount( em,
                     'hardware/flowtracking/capabilities/mirrorOnDrop',
                     'HwFlowTracking::Capabilities', 'ri' )
