#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCliModes
import CliCommand
import CliMatcher
# pylint: disable-next=consider-using-from-import
import CliPlugin.TapAggPmapCli as TapAggPmapCli
# pylint: disable-next=consider-using-from-import
import CliPlugin.TapAggIntfCli as TapAggIntfCli
from CliToken.Clear import clearKwNode

matcherSession = CliMatcher.KeywordMatcher( 'session',
   helpdesc='Clear TAP aggregation policy-map counters in current session' )
matcherTap = CliMatcher.KeywordMatcher( 'tap',
   helpdesc='TAP aggregation' )
matcherAggregation = CliMatcher.KeywordMatcher( 'aggregation',
   helpdesc='TAP aggregation' )
matcherCounters = CliCommand.guardedKeyword( 'counters',
   helpdesc='Clear TAP aggregation counters',
   guard=TapAggIntfCli.counterAccessGuard )
matcherTunnel = CliCommand.guardedKeyword( 'tunnel',
   helpdesc='Reset count of tunnel packets',
   guard=TapAggIntfCli.tapTunnelCounterAccessGuard )

#--------------------------------------------------------------------------------
# clear policy-map type tapagg counters [ PMAPNAME ] [ session ]
#--------------------------------------------------------------------------------
class ClearPolicyMapTypeTapaggCountersCmd( CliCommand.CliCommandClass ):
   syntax = 'clear policy-map type tapagg counters [ PMAPNAME ] [ session ]'
   data = {
      'clear': clearKwNode,
      'policy-map': CliCommand.Node( matcher=CliMatcher.KeywordMatcher( 'policy-map',
         helpdesc='Clear Policy Map' ), guard=TapAggPmapCli.guardPMapTapAgg ),
      'type': 'Specify type',
      'tapagg': CliCommand.Node( matcher=CliMatcher.KeywordMatcher( 'tapagg',
         helpdesc='TAP aggregation type' ), guard=TapAggPmapCli.guardPMapTapAgg ),
      'counters': 'Clear TAP aggregation policy-map counters',
      'session': matcherSession,
      'PMAPNAME': CliMatcher.DynamicNameMatcher( TapAggPmapCli.getPMapNameRuleTapAgg,
         'TAP aggregation Policy Map Name' ),
   }
   handler = TapAggPmapCli.clearTapAggPMapCounters

BasicCliModes.EnableMode.addCommandClass( ClearPolicyMapTypeTapaggCountersCmd )

#--------------------------------------------------------------------------------
# clear tap aggregation counters default-forwarding
#--------------------------------------------------------------------------------
class ClearTapAggCountersDefaultForwardingCmd( CliCommand.CliCommandClass ):
   syntax = 'clear tap aggregation counters default-forwarding'
   data = {
      'clear': clearKwNode,
      'tap': matcherTap,
      'aggregation': matcherAggregation,
      'counters': matcherCounters,
      'default-forwarding': 'Reset count of packets forwarded '
                            'using the default forwarding action',
   }
   handler = TapAggIntfCli.doResetAllTapPortCounters

BasicCliModes.EnableMode.addCommandClass( ClearTapAggCountersDefaultForwardingCmd )

#--------------------------------------------------------------------------------
# clear tap aggregation counters tunnel termination gre
#--------------------------------------------------------------------------------
class ClearTapAggCountersTunnelCmd( CliCommand.CliCommandClass ):
   syntax = 'clear tap aggregation counters tunnel termination gre'
   data = {
      'clear': clearKwNode,
      'tap': matcherTap,
      'aggregation': matcherAggregation,
      'counters': matcherCounters,
      'tunnel': matcherTunnel,
      'termination': 'Tunnel termination',
      'gre': 'GRE tunnel termination',
   }
   handler = TapAggIntfCli.doResetAllTapTunnelCounters

BasicCliModes.EnableMode.addCommandClass( ClearTapAggCountersTunnelCmd )
