#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCliModes
import CliCommand
import CliMatcher
# pylint: disable-next=consider-using-from-import
import CliPlugin.TapAggIntfCli as TapAggIntfCli
# pylint: disable-next=consider-using-from-import
import CliPlugin.TapAggPmapCli as TapAggPmapCli
# pylint: disable-next=consider-using-from-import
import CliPlugin.MirroringClassMapModeTapAgg as MirroringClassMapModeTapAgg
# pylint: disable-next=consider-using-from-import
import CliPlugin.MirroringTapAggConfigMode as MirroringTapAggConfigMode

matcherAggregation = CliMatcher.KeywordMatcher( 'aggregation',
   helpdesc='Configure tap aggregation' )
matcherTap = CliMatcher.KeywordMatcher( 'tap',
   helpdesc='Configure tap aggregation' )
matcherClassMap = CliMatcher.KeywordMatcher( 'class-map',
   helpdesc='Configure Class Map' )
matcherMatchAny = CliMatcher.KeywordMatcher( 'match-any',
   helpdesc='Logical-OR all match statements under this class-map' )
nodeClassMap = CliCommand.Node( matcher=matcherClassMap,
   guard=TapAggPmapCli.guardPMapTapAgg )
nodeTap = CliCommand.Node( matcher=matcherTap, guard=TapAggIntfCli.tapaggGuard )

#--------------------------------------------------------------------------------
# tap aggregation
# ( no | default ) tap aggregation ...
#--------------------------------------------------------------------------------
class TapAggregationCmd( CliCommand.CliCommandClass ):
   syntax = 'tap aggregation'
   noOrDefaultSyntax = 'tap aggregation ...'
   data = {
      'tap': nodeTap,
      'aggregation': matcherAggregation,
   }
   handler = TapAggIntfCli.gotoTapAggregationMode
   noOrDefaultHandler = TapAggIntfCli.noTapAggregationConfig

BasicCliModes.GlobalConfigMode.addCommandClass( TapAggregationCmd )

#--------------------------------------------------------------------------------
# class-map type tapagg match-any CMAPNAME
# [ no | default ] class-map type tapagg [ match-any ] CMAPNAME
#--------------------------------------------------------------------------------
class ClassMapTypeTapaggCmapnameCmd( CliCommand.CliCommandClass ):
   syntax = 'class-map type tapagg match-any CMAPNAME'
   noOrDefaultSyntax = 'class-map type tapagg [ match-any ] CMAPNAME'
   data = {
      'class-map': nodeClassMap,
      'type': MirroringTapAggConfigMode.matcherType,
      'tapagg': CliCommand.Node( matcher=MirroringTapAggConfigMode.matcherTapagg,
         guard=TapAggPmapCli.guardPMapTapAgg ),
      'match-any': matcherMatchAny,
      'CMAPNAME': CliMatcher.DynamicNameMatcher(
         TapAggPmapCli.getCMapNameRuleTapAgg, 'Class Map Name' ),
   }
   handler = MirroringClassMapModeTapAgg.gotoClassMapMode
   noOrDefaultHandler = MirroringClassMapModeTapAgg.deleteClassMap

BasicCliModes.GlobalConfigMode.addCommandClass( ClassMapTypeTapaggCmapnameCmd )

#--------------------------------------------------------------------------------
# [ no | default ] policy-map type tapagg PMAPNAME
#--------------------------------------------------------------------------------
class PolicyMapTypeTapaggPmapnameCmd( CliCommand.CliCommandClass ):
   syntax = 'policy-map type tapagg PMAPNAME'
   noOrDefaultSyntax = syntax
   data = {
      'policy-map': CliCommand.Node( matcher=CliMatcher.KeywordMatcher(
         'policy-map', helpdesc='Configure Policy Map' ),
         guard=TapAggPmapCli.guardPMapTapAgg ),
      'type': MirroringTapAggConfigMode.matcherType,
      'tapagg': CliCommand.Node( matcher=MirroringTapAggConfigMode.matcherTapagg,
         guard=TapAggPmapCli.guardPMapTapAgg ),
      'PMAPNAME': CliMatcher.DynamicNameMatcher(
         TapAggPmapCli.getPMapNameRuleTapAgg, 'TapAgg Policy Map Name' ),
   }
   handler = TapAggPmapCli.gotoPolicyMapMode
   noOrDefaultHandler = TapAggPmapCli.deletePolicyMap

BasicCliModes.GlobalConfigMode.addCommandClass( PolicyMapTypeTapaggPmapnameCmd )
