#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCliModes
import CliCommand
from CliPlugin import MlagConfigCli
from CliPlugin.MlagShowCli import mlagSupportedGuard

nodeMlag = CliCommand.guardedKeyword( 'mlag',
      helpdesc='MLAG configuration',
      guard=mlagSupportedGuard )

#--------------------------------------------------------------------------------
# ( no | default ) mlag configuration
#--------------------------------------------------------------------------------
class MlagConfigurationCmd( CliCommand.CliCommandClass ):
   syntax = 'mlag [ configuration ]'
   noOrDefaultSyntax = syntax
   data = {
      'mlag': nodeMlag,
      'configuration': 'MLAG configuration',
   }
   handler = MlagConfigCli.gotoMlagMode
   noOrDefaultHandler = MlagConfigCli.noMlagMode

BasicCliModes.GlobalConfigMode.addCommandClass( MlagConfigurationCmd )
