#!/usr/bin/env python3
# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
from __future__ import absolute_import, division, print_function
import six
from CliPlugin.IgmpSnoopingCliLib import IgmpSnoopingCliHelper
from MlagMountHelper import MlagStatusLazyMounter
mlagStatus = None

@IgmpSnoopingCliHelper.extension
def isPeerIntf( helper, intf ):
   if mlagStatus.mlagState in ( 'primary', 'secondary' ):
      if mlagStatus.peerLinkIntf.intfId == intf:
         return True
   return False

@IgmpSnoopingCliHelper.extension
def getPeerIntf( helper ):
   if mlagStatus.mlagState in ( 'primary', 'secondary' ):
      return mlagStatus.peerLinkIntf.intfId
   return None

@IgmpSnoopingCliHelper.extension
def getLocalIntf( helper, remoteIntf ):
   # Optimizing for the common case where the MlagIntf
   # has the same name.
   intfStatus = mlagStatus.intfStatus.get( remoteIntf )
   if intfStatus and  intfStatus.peerIntfName == remoteIntf:
      return intfStatus.peerIntfName
   else:
      for localIntf, intfStatus in six.iteritems( mlagStatus.intfStatus ):
         if remoteIntf == intfStatus.peerIntfName:
            return localIntf
   return None

@IgmpSnoopingCliHelper.extension
def getLinkStatus( helper, intf ):
   if intf in mlagStatus.intfStatus:
      return mlagStatus.intfStatus[ intf ].localLinkStatus
   return None


def Plugin ( em ):
   global mlagStatus
   IgmpSnoopingCliHelper.register( "Mlag" )
   # LazyMount mlag/status, Mlag::Status and its dependent paths
   mlagStatus = MlagStatusLazyMounter( em )


