# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliCommand
import CliMatcher
import CliParser
from CliPlugin.AleCountersCli import checkCounterFeatureSupported
from CliPlugin.EthIntfCli import EthPhyAutoIntfType
from CliPlugin.LagIntfCli import LagAutoIntfType
from CliPlugin.MplsCli import _singleOrMultiLabelValMatcher
from CliPlugin.SwitchIntfCli import SwitchAutoIntfType
from CliPlugin import MplsCli
from Intf.IntfRange import IntfRangeMatcher
from IntfRangePlugin.LoopbackIntf import LoopbackAutoIntfType
from IntfRangePlugin.VlanIntf import VlanAutoIntfType
from Toggles.AleToggleLib import toggleAleMplsRouteAckEnabled
from TypeFuture import TacLazyType
import ShowCommand

FeatureId = TacLazyType( 'FlexCounters::FeatureId' )

matcherInterface = CliMatcher.KeywordMatcher(
   'interface', helpdesc='Network interface' )
matcherIntfRange = IntfRangeMatcher( explicitIntfTypes=(
   EthPhyAutoIntfType, LagAutoIntfType, LoopbackAutoIntfType,
   VlanAutoIntfType, SwitchAutoIntfType ) )

def mplsInterfaceCountersGuard( mode, token ):
   if checkCounterFeatureSupported( FeatureId.MplsInterfaceIngress ):
      return None
   return CliParser.guardNotThisPlatform

#--------------------------------------------------------------------------------
# show mpls interface [ INTFS ]
#--------------------------------------------------------------------------------
class MplsInterfaceCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show mpls interface [ INTFS ]'
   data = {
      'mpls' : MplsCli.mplsNodeForShow,
      'interface' : matcherInterface,
      'INTFS' : matcherIntfRange,
   }
   handler = "MplsCliShowCommandsHandler.generateInterfaceModel"
   cliModel = "MplsCliModel.MplsInterfaceModel"

BasicCli.addShowCommandClass( MplsInterfaceCmd )

#--------------------------------------------------------------------------------
# show mpls interface [ INTFS ] counters
#--------------------------------------------------------------------------------
class MplsInterfaceCountersCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show mpls interface [ INTFS ] counters'
   data = {
      'mpls' : MplsCli.mplsNodeForShow,
      'interface' : matcherInterface,
      'INTFS' : matcherIntfRange,
      'counters' : CliCommand.guardedKeyword( 'counters',
            helpdesc='MPLS interface ingress counters',
            guard=mplsInterfaceCountersGuard ),
   }
   handler = "MplsCliShowCommandsHandler.showInterfacesMplsCounter"
   cliModel = "MplsCliModel.MplsInterfaceIngressCounters"

BasicCli.addShowCommandClass( MplsInterfaceCountersCmd )

# -----------------------------------------------------------------------------------
# show mpls hardware ale routes acknowledgement [ all ] [ LABELS ]
# -----------------------------------------------------------------------------------
class ShowMplsRouteAckCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show mpls hardware ale routes acknowledgement [ all ] [ LABELS ]'
   data = {
      'mpls' : MplsCli.mplsForShowNode,
      'hardware' : MplsCli.hardwareMatcherForShow,
      'ale' : MplsCli.aleMatcherForShow,
      'routes' : 'Display MPLS routes',
      'acknowledgement' : 'Show MPLS route acknowledgements',
      'all' : 'Show all MPLS route acknowledgements',
      'LABELS' : _singleOrMultiLabelValMatcher,
   }
   handler = "MplsCliShowCommandsHandler.ShowMplsRouteAckCmd_handler"
   cliModel = "MplsCliModel.MplsRouteAckTable"

if toggleAleMplsRouteAckEnabled():
   BasicCli.addShowCommandClass( ShowMplsRouteAckCmd )
