#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCliModes
import CliCommand
import CliMatcher
from CliPlugin.McastCommonCli import mcastRoutingSupportedGuard
import CliPlugin.MsdpCli as MsdpCli # pylint: disable=consider-using-from-import
from CliToken.Router import routerMatcherForConfig

#--------------------------------------------------------------------------------
# [ no | default ] router msdp
#--------------------------------------------------------------------------------
class RouterMsdpCmd( CliCommand.CliCommandClass ):
   syntax = 'router msdp'
   noOrDefaultSyntax = syntax
   data = {
      'router': routerMatcherForConfig,
      'msdp': 
         CliCommand.Node(
            matcher=CliMatcher.KeywordMatcher(
               'msdp', helpdesc='MSDP protocol commands' ),
            guard=mcastRoutingSupportedGuard ),
   }

   @staticmethod
   def handler( mode, args ):
      childMode = mode.childMode( MsdpCli.RouterMsdpBaseMode )
      mode.session_.gotoChildMode( childMode )

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      # delete config all for all VRFs
      for vrfName in MsdpCli.msdpConfig.vrfConfig:
         MsdpCli.deleteRouterMsdpVrfMode( mode, vrfName )
      MsdpCli.msdpDeletionHook()

BasicCliModes.GlobalConfigMode.addCommandClass( RouterMsdpCmd )
