# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import BasicCli
import CliCommand
import ConfigMount
from CliMode.MssClient import MgmtCvxMssMode
from CliPlugin.ControllerCli import serviceKwMatcher
from CliPlugin.ControllerClient import CvxMgmtConfigMode, addNoMgmtCvxCallback

config = None
serviceConfigDir = None

class MgmtCvxMssConfigMode( MgmtCvxMssMode, BasicCli.ConfigModeBase ):
   # Attributes required of every Mode class.
   name = 'mgmt-cvx-mss'
 
   def __init__( self, parent, session ):
      MgmtCvxMssMode.__init__( self )
      BasicCli.ConfigModeBase.__init__( self, parent, session )
 
def disableMssClient( mode, args=None ):
   config.enabled = False
   serviceConfigDir.service[ "MssL3" ].enabled = False

def enableMssClient( mode, args=None ):
   config.enabled = True
   serviceConfigDir.service[ "MssL3" ].enabled = True

class MgmtCvxMssModeCmd( CliCommand.CliCommandClass ):
   syntax = 'service mss'
   noOrDefaultSyntax = syntax
   data = {
      'service': serviceKwMatcher,
      'mss': 'Macro-Segmentation Service',
   }

   @staticmethod
   def handler( mode, args ):
      childMode = mode.childMode( MgmtCvxMssConfigMode )
      mode.session_.gotoChildMode( childMode )
 
   noOrDefaultHandler = enableMssClient

CvxMgmtConfigMode.addCommandClass( MgmtCvxMssModeCmd )
# When the user issues "no mgmt cvx", we have to reset
# the Macro-Segmentation Service
addNoMgmtCvxCallback( enableMssClient )

#--------------------------------------------------------------------------------
# [ no | default ] disabled
#--------------------------------------------------------------------------------
class ShutdownCmd( CliCommand.CliCommandClass ):
   syntax = 'disabled'
   noOrDefaultSyntax = syntax
   data = {
      'disabled' : 'Disable Macro-Segmentation Service on Switch',
   }

   handler = disableMssClient
   noOrDefaultHandler = enableMssClient

MgmtCvxMssConfigMode.addCommandClass( ShutdownCmd )
  
def Plugin( entityManager ):
   global serviceConfigDir
   global config
   
   config = ConfigMount.mount( entityManager, 
                               'mssclient/config', 'MssClient::Config', 'w' )
   serviceConfigDir = ConfigMount.mount( entityManager,
                                         "mgmt/controller/service/config",
                                         "Controller::ServiceConfigDir", "w" )
