# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import Cell
import CliCommand
import CliParser
from CliToken.Hardware import hardwareMatcherForShow
import ShowCommand

def ejectorHandleGuard( mode, token ):
   if Cell.cellType() == "supervisor":
      return None

   return CliParser.guardNotThisPlatform

#--------------------------------------------------------------------------------
# show hardware fabric ejector-handle
#--------------------------------------------------------------------------------
class HardwareFabricEjectorHandleCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show hardware fabric ejector-handle'
   data = {
      'hardware' : hardwareMatcherForShow,
      'fabric' : 'Fabric card configuration',
      'ejector-handle' : CliCommand.guardedKeyword(
          'ejector-handle',
          helpdesc='Ejector handle configuration',
          guard=ejectorHandleGuard ),
   }

   handler = 'NorCalCardCliHandler.doShowHardwareEjectorHandle'
   cliModel = 'NorCalCardCliModel.HardwareFabricEjectorHandleModel'
   privileged = True

BasicCli.addShowCommandClass( HardwareFabricEjectorHandleCmd )
