#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
import CliParser
import CliPlugin.IntfCli as IntfCli # pylint: disable=consider-using-from-import
import CliPlugin.Ntp as Ntp # pylint: disable=consider-using-from-import

class NtpServeModelet( CliParser.Modelet ):
   @staticmethod
   def shouldAddModeletRule( mode ):
      # this should be if the interface supports IP, but this is
      # probably "close enough"
      return mode.intf.routingSupported()

#--------------------------------------------------------------------------------
# [ no | default ] ntp serve
#--------------------------------------------------------------------------------
class NtpServeCmd( CliCommand.CliCommandClass ):
   syntax = 'ntp serve'
   noOrDefaultSyntax = 'ntp serve ...'
   data = {
      'ntp': 'Configure NTP',
      'serve': 'Accept NTP requests on this interface',
   }
   handler = Ntp.doNtpServeIntf
   noHandler = Ntp.doRemoveNtpServeIntf
   defaultHandler = Ntp.doRemoveServerModeConfig

NtpServeModelet.addCommandClass( NtpServeCmd )
IntfCli.IntfConfigMode.addModelet( NtpServeModelet )
