#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliMatcher
import CliPlugin.AclCli as AclCli # pylint: disable=consider-using-from-import
from CliPlugin.AclCliModel import AllAclList
import CliPlugin.Ntp as Ntp # pylint: disable=consider-using-from-import
from CliPlugin.NtpModels import NtpPeers
import ShowCommand

matcherNtp = CliMatcher.KeywordMatcher( 'ntp', helpdesc='NTP' )

#--------------------------------------------------------------------------------
# show ntp associations
#--------------------------------------------------------------------------------
class NtpAssociationsCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show ntp associations'
   data = {
      'ntp': matcherNtp,
      'associations': 'Associations with NTP peers',
   }
   handler = Ntp.doShowNtpAssociations
   cliModel = NtpPeers

BasicCli.addShowCommandClass( NtpAssociationsCmd )

#--------------------------------------------------------------------------------
# show ntp ( ip | ipv6 ) access-list [<acl-name>]
#--------------------------------------------------------------------------------
class ShowNtpAcl( ShowCommand.ShowCliCommandClass ):
   syntax = ( 'show ntp'
              '('
              ' ( ip access-list [ <ipAclName> ] ) | '
              ' ( ipv6 access-list [ <ipv6AclName> ] ) '
              ')' )
   data = {
            'ntp': matcherNtp,
            'ip': AclCli.ipKwForShowServiceAcl,
            'ipv6': AclCli.ipv6KwForShowServiceAcl,
            'access-list': AclCli.accessListKwMatcherForServiceAcl,
            '<ipAclName>': AclCli.ipAclNameExpression,
            '<ipv6AclName>': AclCli.ip6AclNameExpression
          }
   cliModel = AllAclList
   handler = Ntp.showNtpIpAcl

BasicCli.addShowCommandClass( ShowNtpAcl )

#--------------------------------------------------------------------------------
# show ntp status
#--------------------------------------------------------------------------------
class NtpStatusCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show ntp status'
   data = {
      'ntp': matcherNtp,
      'status': 'Synchronization status',
   }
   cliModel = Ntp.ShowNtpStatusCmdModel

   handler = Ntp.doShowNtpStatus

BasicCli.addShowCommandClass( NtpStatusCmd )
