#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCli
import ShowCommand
# pylint: disable-next=consider-using-from-import
import CliPlugin.TrackingCli as TrackingCli
from CliPlugin.IraIp6Cli import briefKwMatcher

#--------------------------------------------------------------------------------
# show track [ brief | OBJNAME ]
#--------------------------------------------------------------------------------
class TrackCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show track [ ( brief | OBJNAME ) ]'
   data = {
      'track' : TrackingCli.matcherTrackForShow,
      'brief' : briefKwMatcher,
      'OBJNAME' : TrackingCli.matcherObjName,
   }
   handler = TrackingCli.showTrackCommand

BasicCli.addShowCommandClass( TrackCmd )
