#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCliModes
import CliCommand
import CliMatcher
from CliPlugin import AclCli
from CliPlugin import ConfigMgmtMode
from CliPlugin.AclCli import accessListKwMatcherForServiceAcl, countersKwMatcher
from CliToken.Clear import clearKwNode
import LazyMount

matcherApi = CliMatcher.KeywordMatcher( 'api', helpdesc='Clear management APIs' )

aclStatus = None
aclCheckpoint = None

#--------------------------------------------------------------------------------
# clear management api gnmi counters access-list
#--------------------------------------------------------------------------------
class ClearManagementApiGnmiCountersAccessListCmd( CliCommand.CliCommandClass ):
   syntax = 'clear management api gnmi counters access-list'
   data = {
      'clear': clearKwNode,
      'management':  ConfigMgmtMode.managementClearKwMatcher,
      'api': ConfigMgmtMode.apiKwMatcher,
      'gnmi': CliCommand.guardedKeyword( 'gnmi',  
         helpdesc='Clear GNMI statistics', guard=AclCli.serviceAclGuard ),
      'counters': countersKwMatcher,
      'access-list': accessListKwMatcherForServiceAcl,
   }

   @staticmethod
   def handler( mode, args ):
      AclCli.clearServiceAclCounters( mode, aclStatus, aclCheckpoint, 'ip' )

BasicCliModes.EnableMode.addCommandClass( 
      ClearManagementApiGnmiCountersAccessListCmd )

#--------------------------------------------------------------------------------
# clear management api restconf counters access-list
#--------------------------------------------------------------------------------
class ClearManagementApiRestconfCountersAccessListCmd( CliCommand.CliCommandClass ):
   syntax = 'clear management api restconf counters access-list'
   data = {
      'clear': clearKwNode,
      'management': ConfigMgmtMode.managementClearKwMatcher,
      'api': ConfigMgmtMode.apiKwMatcher,
      'restconf': CliCommand.guardedKeyword( 'restconf',
         helpdesc='Clear RESTCONF statistics', guard=AclCli.serviceAclGuard ),
      'counters': countersKwMatcher,
      'access-list': accessListKwMatcherForServiceAcl,
   }

   @staticmethod
   def handler( mode, args ):
      AclCli.clearServiceAclCounters( mode, aclStatus, aclCheckpoint, 'ip' )

BasicCliModes.EnableMode.addCommandClass(
      ClearManagementApiRestconfCountersAccessListCmd )

def Plugin( entityManager ):
   global aclStatus, aclCheckpoint
   aclStatus = LazyMount.mount( entityManager,
                                "acl/status/all",
                                "Acl::Status", "r" )
   aclCheckpoint = LazyMount.mount( entityManager,
                                    "acl/checkpoint",
                                    "Acl::CheckpointStatus", "w" )
