#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCliModes
import CliCommand
from CliPlugin import Gnmi
from CliPlugin import NetconfCli
from CliPlugin import RestconfCli
from CliPlugin import ModelsCli
from CliPlugin.ConfigMgmtMode import managementKwMatcher, apiKwMatcher

#--------------------------------------------------------------------------------
# [ no | default ] management api gnmi
#--------------------------------------------------------------------------------
class ManagementApiGnmiCmd( CliCommand.CliCommandClass ):
   syntax = 'management api gnmi'
   noOrDefaultSyntax = syntax
   data = {
      'management': managementKwMatcher,
      'api': apiKwMatcher,
      'gnmi': 'Configure GNMI',
   }
   handler = Gnmi.gotoMgmtGnmiConfigMode
   noOrDefaultHandler = Gnmi.noMgmtGnmiConfigMode

BasicCliModes.GlobalConfigMode.addCommandClass( ManagementApiGnmiCmd )

#--------------------------------------------------------------------------------
# [ no | default ] management api netconf
#--------------------------------------------------------------------------------
class ManagementApiNetconfCmd( CliCommand.CliCommandClass ):
   syntax = 'management api netconf'
   noOrDefaultSyntax = syntax
   data = {
      'management': managementKwMatcher,
      'api': apiKwMatcher,
      'netconf': 'Configure NETCONF',
   }
   handler = NetconfCli.gotoMgmtNetconfConfigMode
   noOrDefaultHandler = NetconfCli.noMgmtNetconfConfigMode

BasicCliModes.GlobalConfigMode.addCommandClass( ManagementApiNetconfCmd )

#--------------------------------------------------------------------------------
# [ no | default ] management api openconfig
#--------------------------------------------------------------------------------
class ManagementApiOpenconfigCmd( CliCommand.CliCommandClass ):
   syntax = 'management api openconfig'
   noOrDefaultSyntax = syntax
   data = {
      'management': managementKwMatcher,
      'api': apiKwMatcher,
      'openconfig': 'Configure OpenConfig',
   }
   handler = Gnmi.gotoMgmtOpenConfigConfigMode
   noOrDefaultHandler = Gnmi.noMgmtGnmiConfigMode

BasicCliModes.GlobalConfigMode.addCommandClass( ManagementApiOpenconfigCmd )

#--------------------------------------------------------------------------------
# [ no | default ] management api restconf
#--------------------------------------------------------------------------------
class ManagementApiRestconfCmd( CliCommand.CliCommandClass ):
   syntax = 'management api restconf'
   noOrDefaultSyntax = syntax
   data = {
      'management': managementKwMatcher,
      'api': apiKwMatcher,
      'restconf': 'Configure RESTCONF',
   }
   handler = RestconfCli.gotoMgmtRestconfConfigMode
   noOrDefaultHandler = RestconfCli.noMgmtRestconfConfigMode

BasicCliModes.GlobalConfigMode.addCommandClass( ManagementApiRestconfCmd )

#--------------------------------------------------------------------------------
# [ no | default ] management api models
#--------------------------------------------------------------------------------
class ManagementApiModelsCmd( CliCommand.CliCommandClass ):
   syntax = 'management api models'
   noOrDefaultSyntax = syntax
   data = {
      'management': managementKwMatcher,
      'api': apiKwMatcher,
      'models': 'Configure models',
   }
   handler = ModelsCli.gotoMgmtModelsConfigMode
   noOrDefaultHandler = ModelsCli.noMgmtModelsConfigMode

BasicCliModes.GlobalConfigMode.addCommandClass( ManagementApiModelsCmd )
