#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
from CliMatcher import DynamicNameMatcher
import CliParserCommon
from CliPlugin import Gnmi
import ConfigMount

octaConfig = None
gnmiConfig = None

#--------------------------------------------------------------------------------
# [ no | default ] transport grpc TRANSPORT_NAME
#--------------------------------------------------------------------------------
class TransportGrpcCmd( CliCommand.CliCommandClass ):
   syntax = 'transport grpc TRANSPORT_NAME'
   noOrDefaultSyntax = syntax
   data = {
      'transport': 'Configure a transport',
      'grpc': 'Configure gRPC transport for gNMI',
      'TRANSPORT_NAME': DynamicNameMatcher( lambda mode: gnmiConfig.endpoints,
                                            'Transport name', helpname='WORD',
          extraEmptyTokenCompletionFn=lambda mode, context:
            [ CliParserCommon.Completion( endpoint, endpoint )
            for endpoint in gnmiConfig.endpoints ] ),
   }
   handler = Gnmi.gotoGnmiTransportConfigMode
   noOrDefaultHandler = Gnmi.noGnmiTransportConfigMode

Gnmi.MgmtGnmiConfigMode.addCommandClass( TransportGrpcCmd )

#--------------------------------------------------------------------------------
# [ no | default ] transport grpc-tunnel TRANSPORT
#--------------------------------------------------------------------------------
class TransportGrpctunnelCmd( CliCommand.CliCommandClass ):
   syntax = 'transport grpc-tunnel TRANSPORT'
   noOrDefaultSyntax = syntax
   data = {
      'transport': 'Configure a transport',
      'grpc-tunnel': 'Configure gRPC-tunnel dial-out transport for gNMI',
      'TRANSPORT': DynamicNameMatcher( lambda mode: gnmiConfig.grpctunnelClients,
                                       'Transport name', helpname='WORD',
       extraEmptyTokenCompletionFn=lambda mode, context: 
                     [ CliParserCommon.Completion( tunnelClient, tunnelClient )
                      for tunnelClient in gnmiConfig.grpctunnelClients ] ),
   }
   handler = Gnmi.gotoGrpctunnelTransportConfigMode
   noOrDefaultHandler = Gnmi.noGrpctunnelTransportConfigMode

Gnmi.MgmtGnmiConfigMode.addCommandClass( TransportGrpctunnelCmd )

#--------------------------------------------------------------------------------
# [ no | default ] provider eos-native
#--------------------------------------------------------------------------------
class ProviderEosNativeCmd( CliCommand.CliCommandClass ):
   syntax = 'provider eos-native'
   noOrDefaultSyntax = syntax
   data = {
      'provider': 'Configure provider for gNMI',
      'eos-native': 'Configure native path support for gNMI',
   }

   @staticmethod
   def handler( mode, args ):
      octaConfig.enabled = True

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      octaConfig.enabled = False

Gnmi.MgmtGnmiConfigMode.addCommandClass( ProviderEosNativeCmd )

#--------------------------------------------------------------------------------
# [ no | default ] operation set persistence
#--------------------------------------------------------------------------------
class OpSetPersistenceCmd( CliCommand.CliCommandClass ):
   syntax = 'operation set persistence'
   noOrDefaultSyntax = syntax
   data = {
      'operation': 'Configure gNMI operation',
      'set': 'Configure gNMI set',
      'persistence': 'Configure persistence of gNMI set'
   }

   @staticmethod
   def handler( mode, args ):
      gnmiConfig.setPersistence = True

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      gnmiConfig.setPersistence = False

Gnmi.MgmtGnmiConfigMode.addCommandClass( OpSetPersistenceCmd )


def Plugin( entityManager ):
   global octaConfig
   global gnmiConfig
   octaConfig = ConfigMount.mount( entityManager, "mgmt/octa/config",
                                   "Octa::Config", "w" )
   gnmiConfig = ConfigMount.mount( entityManager, "mgmt/gnmi/config",
                                   "Gnmi::Config", "w" )
