# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
from CliPlugin import ModelsCli
import Toggles.RoutingLibToggleLib as RoutingLibToggle
import Toggles.OpenConfigToggleLib as OCToggle

#--------------------------------------------------------------------------------
# [ no | default ] provider aft
#--------------------------------------------------------------------------------
class ProviderAFTCmd( CliCommand.CliCommandClass ):
   syntax = 'provider aft'
   noOrDefaultSyntax = syntax
   data = {
      'provider': 'Configure a provider',
      'aft': 'Configure AFT provider',
   }
   handler = ModelsCli.gotoProviderAFTConfigMode
   noOrDefaultHandler = ModelsCli.noProviderAFTConfigMode

#--------------------------------------------------------------------------------
# [ no | default ] provider smash
#--------------------------------------------------------------------------------
class ProviderSmashCmd( CliCommand.CliCommandClass ):
   syntax = 'provider smash'
   noOrDefaultSyntax = syntax
   data = {
      'provider': 'Configure a provider',
      'smash': 'Configure Smash provider',
   }
   handler = ModelsCli.gotoProviderSmashConfigMode
   noOrDefaultHandler = ModelsCli.noProviderSmashConfigMode

#--------------------------------------------------------------------------------
# [ no | default ] provider sysdb
#--------------------------------------------------------------------------------
class ProviderSysdbCmd( CliCommand.CliCommandClass ):
   syntax = 'provider sysdb'
   noOrDefaultSyntax = syntax
   data = {
      'provider': 'Configure a provider',
      'sysdb': 'Configure Sysdb provider',
   }
   handler = ModelsCli.gotoProviderSysdbConfigMode
   noOrDefaultHandler = ModelsCli.noProviderSysdbConfigMode

#--------------------------------------------------------------------------------
# [ no | default ] provider ipfix
#--------------------------------------------------------------------------------
class ProviderIPFIXCmd( CliCommand.CliCommandClass ):
   syntax = 'provider ipfix'
   noOrDefaultSyntax = syntax
   data = {
      'provider': 'Configure a provider',
      'ipfix': 'Configure IPFIX provider',
   }
   handler = ModelsCli.gotoProviderIPFIXConfigMode
   noOrDefaultHandler = ModelsCli.noProviderIPFIXConfigMode

#--------------------------------------------------------------------------------
# [ no | default ] provider sflow
#--------------------------------------------------------------------------------
class ProviderSflowCmd( CliCommand.CliCommandClass ):
   syntax = 'provider sflow'
   noOrDefaultSyntax = syntax
   data = {
      'provider': 'Configure a provider',
      'sflow': 'Configure sFlow provider',
   }
   handler = ModelsCli.gotoProviderSflowConfigMode
   noOrDefaultHandler = ModelsCli.noProviderSflowConfigMode

#--------------------------------------------------------------------------------
# [ no | default ] provider http-commmands
#--------------------------------------------------------------------------------
class ProviderHttpCommandsCmd( CliCommand.CliCommandClass ):
   syntax = 'provider http-commands'
   noOrDefaultSyntax = syntax
   data = {
      'provider': 'Configure a provider',
      'http-commands': 'Configure Http Commands provider',
   }
   handler = ModelsCli.gotoProviderHttpCommandsConfigMode
   noOrDefaultHandler = ModelsCli.noProviderHttpCommandsConfigMode

#--------------------------------------------------------------------------------
# [ no | default ] provider isis
#--------------------------------------------------------------------------------
class ProviderIsisCmd( CliCommand.CliCommandClass ):
   syntax = 'provider isis'
   noOrDefaultSyntax = syntax
   data = {
      'provider' : 'Configure a provider',
      'isis' : 'Configure IS-IS provider',
   }
   handler = ModelsCli.gotoProviderIsisConfigMode
   noOrDefaultHandler = ModelsCli.noProviderIsisConfigMode

#--------------------------------------------------------------------------------
# [ no | default ] provider ospf
# --------------------------------------------------------------------------------
class ProviderOspfCmd( CliCommand.CliCommandClass ):
   syntax = 'provider ospf'
   noOrDefaultSyntax = syntax
   data = {
      'provider': 'Configure a provider',
      'ospf': 'Configure OSPFv2 provider',
   }
   handler = ModelsCli.gotoProviderOspfConfigMode
   noOrDefaultHandler = ModelsCli.noProviderOspfConfigMode

# --------------------------------------------------------------------------------
# [ no | default ] provider bgp
#--------------------------------------------------------------------------------
class ProviderBgpCmd( CliCommand.CliCommandClass ):
   syntax = 'provider bgp'
   noOrDefaultSyntax = syntax
   data = {
      'provider' : 'Configure a provider',
      'bgp' : 'Configure BGP provider',
   }
   handler = ModelsCli.gotoProviderBgpConfigMode
   noOrDefaultHandler = ModelsCli.noProviderBgpConfigMode

#--------------------------------------------------------------------------------
# [ no | default ] provider macsec
#--------------------------------------------------------------------------------
class ProviderMacsecCmd( CliCommand.CliCommandClass ):
   syntax = 'provider macsec'
   noOrDefaultSyntax = syntax
   data = {
      'provider' : 'Configure a provider',
      'macsec' : 'Configure macsec provider',
   }
   handler = ModelsCli.gotoProviderMacsecConfigMode
   noOrDefaultHandler = ModelsCli.noProviderMacsecConfigMode

#--------------------------------------------------------------------------------
# [ no | default ] provider configuration
#--------------------------------------------------------------------------------
class ProviderConfigurationCmd( CliCommand.CliCommandClass ):
   syntax = 'provider configuration'
   noOrDefaultSyntax = syntax
   data = {
      'provider' : 'Configure a provider',
      'configuration' : 'Configure Configuration provider',
   }
   handler = ModelsCli.gotoProviderConfigurationConfigMode
   noOrDefaultHandler = ModelsCli.noProviderConfigurationConfigMode

#--------------------------------------------------------------------------------
# [ no | default ] models
#--------------------------------------------------------------------------------
class ModelsCmd( CliCommand.CliCommandClass ):
   syntax = 'models'
   noOrDefaultSyntax = syntax
   data = {
      'models': 'Configure YANG paths',
   }
   handler = ModelsCli.gotoModelsConfigMode
   noOrDefaultHandler = ModelsCli.noModelsConfigMode

#--------------------------------------------------------------------------------
# [ no | default ] modules
#--------------------------------------------------------------------------------
class ModulesCmd( CliCommand.CliCommandClass ):
   syntax = 'modules'
   noOrDefaultSyntax = syntax
   data = {
      'modules': 'Configure YANG modules',
   }
   handler = ModelsCli.gotoModulesConfigMode
   noOrDefaultHandler = ModelsCli.noModulesConfigMode

# --------------------------------------------------------------------------------
# [ no | default ] leaf default-value visible
# --------------------------------------------------------------------------------
class DefaultLeafsVisibilityCmd( CliCommand.CliCommandClass ):
   syntax = 'leaf default-value visible'
   noOrDefaultSyntax = syntax
   data = {
      'leaf': 'Configure YANG leaf behavior',
      'default-value': 'Configure default-leaf behavior',
      'visible': 'Configure visibility of default-leafs',
   }
   handler = ModelsCli.showDefaultLeafs
   noOrDefaultHandler = ModelsCli.noShowDefaultLeafs

ModelsCli.MgmtModelsConfigMode.addCommandClass( ProviderAFTCmd )
ModelsCli.MgmtModelsConfigMode.addCommandClass( ProviderSmashCmd )
ModelsCli.MgmtModelsConfigMode.addCommandClass( ProviderSysdbCmd )
ModelsCli.MgmtModelsConfigMode.addCommandClass( ProviderIPFIXCmd )
ModelsCli.MgmtModelsConfigMode.addCommandClass( ProviderSflowCmd )
ModelsCli.MgmtModelsConfigMode.addCommandClass( ProviderHttpCommandsCmd )
ModelsCli.MgmtModelsConfigMode.addCommandClass( ProviderMacsecCmd )
ModelsCli.MgmtModelsConfigMode.addCommandClass( ProviderIsisCmd )
ModelsCli.MgmtModelsConfigMode.addCommandClass( ProviderConfigurationCmd )

if RoutingLibToggle.toggleOspf2LsdbExportEnabled():
   ModelsCli.MgmtModelsConfigMode.addCommandClass( ProviderOspfCmd )

ModelsCli.MgmtModelsConfigMode.addCommandClass( ProviderBgpCmd )

ModelsCli.MgmtModelsConfigMode.addCommandClass( ModelsCmd )

ModelsCli.MgmtModelsConfigMode.addCommandClass( ModulesCmd )

if OCToggle.toggleOCDefaultLeafsResponseToggleEnabled():
   ModelsCli.MgmtModelsConfigMode.addCommandClass( DefaultLeafsVisibilityCmd )
