#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCli
import BasicCliModes
import CliCommand
import CliPlugin.P4RuntimeCli as P4RuntimeCli
from CliMode.P4RuntimeMode import P4RuntimeMode

class P4RuntimeConfigMode( P4RuntimeMode, BasicCli.ConfigModeBase ):
   """ p4-runtime configuration mode """
   name = "P4 Runtime Configuration"

   def __init__( self, parent, session ):
      P4RuntimeMode.__init__( self, None )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

def gotoP4RuntimeMode( mode, args ):
   childMode = mode.childMode( P4RuntimeConfigMode )
   mode.session_.gotoChildMode( childMode )

def noP4RtConfigMode( mode, args ):
   P4RuntimeCli.resetP4Runtime( mode, args )

#--------------------------------------------------------------------------------
# [ no | default ] p4-runtime
#--------------------------------------------------------------------------------
class P4RuntimeCmd( CliCommand.CliCommandClass ):
   syntax = 'p4-runtime'
   noOrDefaultSyntax = syntax
   data = {
      'p4-runtime': CliCommand.guardedKeyword( 'p4-runtime',
                                       helpdesc='P4 Runtime commands',
                                       guard=P4RuntimeCli.p4RuntimeSupportedGuard ),
   }
   handler = gotoP4RuntimeMode
   noOrDefaultHandler = noP4RtConfigMode

BasicCliModes.GlobalConfigMode.addCommandClass( P4RuntimeCmd )
