#!/usr/bin/env python3
# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliPlugin import PbrModel
from CliPlugin.PolicyMapModelImpl import ActionBase, PolicyClassMapBase
from PbrLib import tacPbrActionSetDscp, \
                   tacPbrClassMapStatus, tacPbrTtlAction, tacPbrNoAction, \
                   tacPbrDropAction, tacPbrNexthopAction, tacPbrNexthopGroupAction
from ArnetModel import IpGenericAddr

class NoAction:
   @classmethod
   def createModel( cls, noAction ):
      model = PbrModel.NoActionModel()
      model.actionType = noAction.actionType
      return model

ActionBase.addActionType( tacPbrNoAction, NoAction )

class DropAction:
   @classmethod
   def createModel( cls, dropAction ):
      model = PbrModel.DropActionModel()
      model.actionType = dropAction.actionType
      return model

ActionBase.addActionType( tacPbrDropAction, DropAction )

class NexthopAction:
   @classmethod
   def createModel( cls, nexthopAction ):
      model = PbrModel.NexthopModel()
      model.recursive = nexthopAction.recursive
      model.vrfName = nexthopAction.vrfName
      pos = 0
      for addr in sorted( nexthopAction.nexthop.keys() ):
         addrModel = IpGenericAddr()
         addrModel.ip = addr
         model.nexthops[ pos ] = addrModel
         pos += 1
      model.actionType = nexthopAction.actionType
      return model

ActionBase.addActionType( tacPbrNexthopAction, NexthopAction )

class NexthopGroupAction:
   @classmethod
   def createModel( cls, nexthopGroupAction ):
      model = PbrModel.NexthopGroupModel()
      model.nexthopGroup = nexthopGroupAction.nexthopGroup
      model.actionType = nexthopGroupAction.actionType
      return model

ActionBase.addActionType( tacPbrNexthopGroupAction, NexthopGroupAction )

class SetDscp:
   @classmethod
   def createModel( cls, dscpVal ):
      model = PbrModel.SetDscpModel()
      model.actionType = dscpVal.actionType
      model.dscpValue = dscpVal.dscp
      return model

ActionBase.addActionType( tacPbrActionSetDscp, SetDscp )

class SetTtl:
   @classmethod
   def createModel( cls, ttlVal ):
      model = PbrModel.SetTtlModel()
      model.actionType = ttlVal.actionType
      model.ttlValue = ttlVal.ttl
      return model

ActionBase.addActionType( tacPbrTtlAction, SetTtl )

class PbrPolicyClassMap:   
   @classmethod
   def createModel( cls, statuses ):

      model = PbrModel.PbrPolicyClassMapModel()
      statusAll = [ ] 

      if not statuses:
         return model
      if hasattr( statuses , '__iter__' ):
         if not statuses:
            return model

         for s in statuses:
            statusAll.append( s )

      #get action, nexthop, nexthopgroup for each vrf
      for status in statusAll:
         for vrfName in status.pbrClassMapVrfStatus:

            if vrfName in model.vrfs:
               continue

            vrfModel = PbrModel.PbrPolicyClassMapVrfModel()
            s = status.pbrClassMapVrfStatus[ vrfName ]
            action = s.actionType
            vrfModel.action = action
            if action == 'nexthopAction':
               for via in s.resolvedNexthopInfo.viasActive:
                  addrModel = IpGenericAddr()
                  addrModel.ip = via.ip
                  vrfModel.nexthops.append( addrModel )
               vrfModel.actionVrf = s.resolvedNexthopInfo.nexthopSet.vrfName
               vrfModel.ttl = s.ttl
            elif action == 'nexthopGroupAction':
               vrfModel.nexthopGroup = s.nexthopGroup
               vrfModel.ttl = s.ttl
            model.vrfs[ vrfName ] = vrfModel

      return model

PolicyClassMapBase.addStatusType( tacPbrClassMapStatus, PbrPolicyClassMap )
