# Copyright (c) 2010, 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import Cell
import CliCommand
import CliParser
from CliPlugin import TechSupportCli
import CliToken.Clear
import ShowCommand


pciDeviceConfigDir = None

def pciGuard( mode, token ):
   if pciDeviceConfigDir and pciDeviceConfigDir.pciDeviceConfig:
      return None
   else:
      return CliParser.guardNotThisPlatform

nodePci = CliCommand.guardedKeyword( 'pci',
      helpdesc='Display PCIe devices with error counters', guard=pciGuard )

#--------------------------------------------------------------------------------
# show pci
#--------------------------------------------------------------------------------
class PciCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show pci'
   data = {
      'pci' : nodePci,
   }
   cliModel = "PciCliHandlers.PciErrors"
   privileged = True
   prepareFunction = "PciCliHandlers.prepShowPci"
   handler = "PciCliHandlers.pciCmdHandler"

BasicCli.addShowCommandClass( PciCmd )

#--------------------------------------------------------------------------------
# show pci detail
#--------------------------------------------------------------------------------
class PciDetailCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show pci detail'
   data = {
      'pci' : nodePci,
      'detail' : 'Display PCIe devices with Advanced Error Reporting error counters',
   }
   cliModel = "PciCliHandlers.PciDetailErrors"
   privileged = True
   handler = "PciCliHandlers.pciDetailCmdHandler"

BasicCli.addShowCommandClass( PciDetailCmd )

#--------------------------------------------------------------------------------
# show pci errors rates
#--------------------------------------------------------------------------------
class PciErrorsRatesCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show pci errors rates'
   data = {
      'pci' : nodePci,
      'errors': 'Display PCIe devices errors',
      'rates' : 'Display PCIe devices error rates',
   }
   cliModel = "PciCliHandlers.PciErrorsStatsAll"
   privileged = True
   handler = "PciCliHandlers.pciErrorsRatesCmdHandler"

BasicCli.addShowCommandClass( PciErrorsRatesCmd )

#--------------------------------------------------------------------------------
# show pci errors rates detail
#--------------------------------------------------------------------------------
class PciErrorsRatesDetailCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show pci errors rates detail'
   data = {
      'pci' : nodePci,
      'errors': 'Display PCIe devices errors',
      'rates' : 'Display PCIe devices error rates',
      'detail' : 'Display more information for specific error types'
   }
   cliModel = "PciCliHandlers.PciErrorsStatsDetailAll"
   privileged = True
   handler = "PciCliHandlers.pciErrorsRatesDetailCmdHandler"

BasicCli.addShowCommandClass( PciErrorsRatesDetailCmd )

#--------------------------------------------------------------------------------
# show pci tree
#--------------------------------------------------------------------------------
class PciTreeCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show pci tree'
   data = {
      'pci' : nodePci,
      'tree' : 'Print user space view of Hardware PCI tree',
   }
   cliModel = "PciCliHandlers.PciTreeNode"
   hidden = True
   privileged = True
   handler = "PciCliHandlers.pciTreeCmdHandler"

BasicCli.addShowCommandClass( PciTreeCmd )
                                                      
#--------------------------------------------------------------------------------
# clear pci
#--------------------------------------------------------------------------------
class ClearPciCmd( CliCommand.CliCommandClass ):
   syntax = 'clear pci'
   data = {
      'clear' : CliToken.Clear.clearKwNode,
      'pci' : CliCommand.guardedKeyword( 'pci',
         helpdesc='Clear PCIe devices\' error counters', guard=pciGuard ),
   }
   handler = "PciCliHandlers.clearPciCmdHandler"

BasicCli.EnableMode.addCommandClass( ClearPciCmd )

#------------------------------------------------------
# Commands for 'show tech-support'.
#------------------------------------------------------
def showTechGuard():
   return pciDeviceConfigDir and len( pciDeviceConfigDir.pciDeviceConfig ) > 0

TechSupportCli.registerShowTechSupportCmd(
   '2010-10-15 10:37:37',
   cmds=[ 'show pci',
          'show pci tree',
          'bash lspci' ],
   cmdsGuard=showTechGuard )

TechSupportCli.registerShowTechSupportCmd(
   '2024-02-01 14:31:29',
   cmds=[ 'show pci errors rates',
          'show pci errors rates detail | nz' ],
   cmdsGuard=showTechGuard )

#------------------------------------------------------
# Plugin method
#------------------------------------------------------

def Plugin( em ):
   global pciDeviceConfigDir
   pciDeviceConfigDir = em.mount( \
         f"hardware/cell/{Cell.cellId()}/pciDeviceMap/config",
         "Hardware::PciDeviceConfigDir", "r" )
