# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac

class EnumEntry:
   def __init__( self, tac='', capi='', printed='' ):
      self.tac = tac
      self.capi = capi
      self.printed = printed

# Take tuples consisting of ( tac, capi, printed )
def mkDict( *enums ):
   enumDict = {}
   for enum in enums:
      entry = EnumEntry( *enum )
      if entry.tac:
         enumDict[ entry.tac ] = entry
      if entry.capi:
         enumDict[ entry.capi ] = entry
   return enumDict

def getModel( enumDict ):
   return list( { enumDict[ i ].capi for i in enumDict if enumDict[ i ].capi } )

skewCalStatusEnum = Tac.Type( 'Phy::Coherent::SkewCalibrationStatus' )
skewCalStatus = mkDict(
         ( skewCalStatusEnum.skewNotApplicable, "", "" ),
         ( skewCalStatusEnum.skewOk, "", "ok" ),
         ( skewCalStatusEnum.skewModulation, "modulation", "modulation" ),
         ( skewCalStatusEnum.skewLinkFlap, "linkFlap", "link-flap" ),
         ( skewCalStatusEnum.skewLinkDown, "linkDown", "link-down" ),
         ( skewCalStatusEnum.skewUcb, "uncorrectableCodeBlocksIncrement", "ucb" ),
         ( skewCalStatusEnum.skewConcurrent, "concurrentOperation", "concurrent" )
      )

skewSourceEnum = Tac.Type( 'Phy::Coherent::SkewSource' )
skewSource = mkDict(
         ( skewSourceEnum.skewSourceDefault, "default", "default" ),
         ( skewSourceEnum.skewSourcePstore, "persistent", "persistent" ),
         ( skewSourceEnum.skewSourceComputing, "computing", "computing" )
      )
