# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import CliParser
from CliPlugin import IpAddrMatcher
from CliMatcher import KeywordMatcher, IntegerMatcher
from CliCommand import Node
import LazyMount

#Globals
_routingHwStatus = None

def _pimBidirectionalGuard( mode, token ):
   if _routingHwStatus.pimBidirectionalSupported:
      return None
   else:
      return CliParser.guardNotThisPlatform

groupExpiryTimerMatcher = KeywordMatcher( 'group-expiry-timer',
      helpdesc='Activity timer for groups ( source-only trees )' )
groupExpiryTimerValueMatcher = IntegerMatcher( 1, 210,
      helpdesc='Group activity expiry timer.' )
bidirMatcher = Node(
      KeywordMatcher( 'bidirectional', helpdesc='Bidirectional Mode PIM' ),
      guard=_pimBidirectionalGuard )
allMroutesBidirMatcher = KeywordMatcher( '*',
      helpdesc='All routes' )
groupBidirMatcher = IpAddrMatcher.IpAddrMatcher( 'Group address' )
detailBidirMatcher = KeywordMatcher( 'detail',
      helpdesc='Detailed route information' )

def Plugin( entityManager ):
   global _routingHwStatus

   _routingHwStatus = LazyMount.mount( entityManager, 
         'routing/hardware/status', 
         'Routing::Hardware::Status', 'r' )



