# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliPlugin import IntfCli
import ConfigMount


pimConfig = None
pim6Config = None

class PimIntf( IntfCli.IntfDependentBase ):
   ''' The PimIntf class is ued to remove the Pim IntfConfig object when
       an interface is deleted.  The Intf class will create a new
       instance of PimIntf and call destroy when the interface is deleted. '''
   def setDefault( self ):
      ''' Destroys the IntfConfig object for this interface if the
          object exists. '''
      name = self.intf_.name
      del pimConfig.intfConfig[ name ]
      del pim6Config.intfConfig[ name ]

def Plugin( entityManager ):
   global pimConfig
   global pim6Config
   pimConfig = ConfigMount.mount( entityManager, 'routing/pim/config',
                                  'Routing::Pim::ConfigColl', 'w' )
   pim6Config = ConfigMount.mount( entityManager, 'routing6/pim/config',
                                  'Routing::Pim::ConfigColl', 'w' )

   IntfCli.Intf.registerDependentClass( PimIntf, priority=21 ) 
