#!/usr/bin/env python3
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
import CliPlugin.PimCliLib
from CliPlugin.AclCli import standardIp6AclNameMatcher
# pylint: disable-next=consider-using-from-import
import CliPlugin.PimsmCliConfig as PimsmCliConfig
from CliToken.Pim import (
      fastRerouteMatcher,
      ssmMatcher,
      ssmRangeMatcher,
      thresholdMatcher,
)

#--------------------------------------------------------------------------------
# fast-reroute ACL
#--------------------------------------------------------------------------------
class FastRerouteAclnameCmd( CliCommand.CliCommandClass ):
   syntax = 'fast-reroute ACL'
   data = {
      'fast-reroute': fastRerouteMatcher,
      'ACL': standardIp6AclNameMatcher,
   }

   handler = PimsmCliConfig.setIpPimsmFrrFilter

CliPlugin.PimCliLib.RouterPimSparseIpv6Modelet.\
   addCommandClass( FastRerouteAclnameCmd )

#--------------------------------------------------------------------------------
# [ no | default ] spt threshold THRESHOLD match list ACL
#--------------------------------------------------------------------------------
class SptThresholdCmd( CliCommand.CliCommandClass ):
   syntax = 'spt threshold THRESHOLD match list ACL'
   noOrDefaultSyntax = 'spt threshold THRESHOLD [ match list ACL ]'
   data = {
      'spt': 'Shortest path tree',
      'threshold': 'Switchover threshold',
      'THRESHOLD': thresholdMatcher,
      'match': 'Match on the following option',
      'list': 'ACL specifying groups threshold applies to',
      'ACL': standardIp6AclNameMatcher,
   }

   handler = PimsmCliConfig.setPimsmSptThresh
   noOrDefaultHandler = PimsmCliConfig.noPimsmSptThresh

CliPlugin.PimCliLib.RouterPimSparseIpv6Modelet.addCommandClass( SptThresholdCmd )

#--------------------------------------------------------------------------------
# ssm range ( standard | ACL )
#--------------------------------------------------------------------------------
class SsmRangeCmd( CliCommand.CliCommandClass ):
   syntax = 'ssm range ( standard | ACL )'
   data = {
      'ssm': ssmMatcher,
      'range': ssmRangeMatcher,
      'standard': 'Sets the SSM range to ff3x::/32',
      'ACL': standardIp6AclNameMatcher,
   }

   handler = PimsmCliConfig.setIpPimsmSsmFilter

CliPlugin.PimCliLib.RouterPimSparseIpv6Modelet.addCommandClass( SsmRangeCmd )
